/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import logicClasses.Airport;
import logicClasses.Controls;
import logicClasses.EntryPoint;
import logicClasses.ExitPoint;
import logicClasses.Flight;
import logicClasses.Point;
import logicClasses.SeparationRules;
import logicClasses.Waypoint;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public class Airspace {
    private int maximumNumberOfFlightsInAirspace = 10;
    private int score = 0;
    private int numberOfGameLoopsSinceLastFlightAdded = 0;
    private int numberOfGameLoopsSinceLastFlightAirport = 500;
    private int numberOfGameLoops = 0;
    private int numberOfGameLoopsWhenDifficultyIncreases = 3600;
    private int randomNumberForFlightGeneration = 500;
    private List<Flight> listOfFlightsInAirspace = new ArrayList<Flight>();
    private List<Waypoint> listOfWayppoints = new ArrayList<Waypoint>();
    private List<EntryPoint> listofEntrypoints = new ArrayList<EntryPoint>();
    private List<ExitPoint> listOfExitPoints = new ArrayList<ExitPoint>();
    private SeparationRules separationRules;
    private Airport airport = new Airport(572.0, 197.0, "BHD");
    private boolean AirportAvailable = true;
    private int difficultyValueOfGame = 0;
    private Controls controls = new Controls();

    public void resetAirspace() {
        this.AirportAvailable = true;
        this.listOfFlightsInAirspace = new ArrayList<Flight>();
        this.numberOfGameLoopsSinceLastFlightAdded = 0;
        this.numberOfGameLoopsSinceLastFlightAirport = 500;
        this.numberOfGameLoops = 0;
        this.score = 0;
        this.numberOfGameLoopsWhenDifficultyIncreases = 3600;
        this.separationRules.setGameOverViolation(false);
        this.controls.setSelectedFlight(null);
    }

    public void createAndSetSeparationRules() {
        this.separationRules = new SeparationRules(this.difficultyValueOfGame);
    }

    public boolean newWaypoint(int x, int y, String name) {
        Waypoint tmpWp;
        return x < 1250 && x > 150 && y < 650 && y > -50 && this.addWaypoint(tmpWp = new Waypoint(x, y, name));
    }

    public boolean newAirport(int x, int y) {
        Airport tmpAp;
        return x < 1250 && x > 150 && y < 650 && y > -50 && this.addAirport(tmpAp = new Airport(x, y, "Airport"));
    }

    public boolean newExitPoint(int x, int y, String name) {
        if (x < 1250 && x > 100 && y < 650 && y > -50) {
            ExitPoint tmpEp = new ExitPoint(x, y, name);
            tmpEp.setPointRef("EXP" + name);
            if (this.addExitPoint(tmpEp)) {
                return true;
            }
        }
        return false;
    }

    public boolean newEntryPoint(int x, int y) {
        EntryPoint tmpEp;
        return x < 1250 && x > 100 && y < 650 && y > -50 && this.addEntryPoint(tmpEp = new EntryPoint(x, y));
    }

    public boolean newFlight(GameContainer gc) throws SlickException {
        if (this.listOfFlightsInAirspace.size() < this.maximumNumberOfFlightsInAirspace && (this.numberOfGameLoopsSinceLastFlightAdded >= 600 || this.listOfFlightsInAirspace.isEmpty())) {
            Random rand = new Random();
            int checkNumber = this.listOfFlightsInAirspace.isEmpty() ? rand.nextInt(100) : rand.nextInt(this.randomNumberForFlightGeneration);
            if (checkNumber < 6) {
                int entry = rand.nextInt(5);
                if (entry == 4 && this.AirportAvailable) {
                    for (int index = 0; index < this.listOfFlightsInAirspace.size(); ++index) {
                        if (this.listOfFlightsInAirspace.get(index).getTakenOff()) continue;
                        this.changeScore(-200);
                        return false;
                    }
                    this.AirportAvailable = false;
                    Flight tempFlight = new Flight(this, 4);
                    tempFlight.setFlightName(this.generateFlightName());
                    tempFlight.setTargetAltitude(0);
                    tempFlight.getFlightPlan().setVelocity(0.0);
                    tempFlight.getFlightPlan().setTargetVelocity(0.0);
                    double heading = tempFlight.calculateHeadingToFirstWaypoint(tempFlight.getFlightPlan().getPointByIndex(0).getX(), tempFlight.getFlightPlan().getPointByIndex(0).getY());
                    tempFlight.setTargetHeading(heading);
                    tempFlight.setCurrentHeading(heading);
                    this.numberOfGameLoopsSinceLastFlightAdded = 0;
                    this.resetNumberOfGameLoopsSinceLastFlightAirport();
                    if (this.listOfFlightsInAirspace.add(tempFlight)) {
                        this.listOfFlightsInAirspace.get(this.listOfFlightsInAirspace.size() - 1).init(gc);
                        return true;
                    }
                } else {
                    Flight tempFlight = new Flight(this, 0);
                    tempFlight.setFlightName(this.generateFlightName());
                    tempFlight.setTargetAltitude(tempFlight.getAltitude());
                    double heading = tempFlight.calculateHeadingToFirstWaypoint(tempFlight.getFlightPlan().getPointByIndex(0).getX(), tempFlight.getFlightPlan().getPointByIndex(0).getY());
                    tempFlight.setTargetHeading(heading);
                    tempFlight.setCurrentHeading(heading);
                    this.numberOfGameLoopsSinceLastFlightAdded = 0;
                    if (this.listOfFlightsInAirspace.add(tempFlight)) {
                        this.listOfFlightsInAirspace.get(this.listOfFlightsInAirspace.size() - 1).init(gc);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public String generateFlightName() {
        String name = "G-";
        Random rand = new Random();
        for (int i = 0; i < 4; ++i) {
            int thisChar = rand.nextInt(10) + 65;
            name = name + (char)thisChar;
        }
        return name;
    }

    public boolean checkIfFlightHasLeftAirspace(Flight flight) {
        return flight.getX() > 1250.0 || flight.getX() < 100.0 || flight.getY() > 650.0 || flight.getY() < -50.0;
    }

    public void changeScore(int value) {
        this.score += value;
    }

    public void increaseDifficulty() {
        this.numberOfGameLoopsWhenDifficultyIncreases += 3600;
        if (this.randomNumberForFlightGeneration - 50 > 0) {
            this.randomNumberForFlightGeneration -= 50;
        }
    }

    public void init(GameContainer gc) throws SlickException {
        int i;
        this.controls.init(gc);
        this.airport.init(gc);
        for (i = 0; i < this.listOfWayppoints.size(); ++i) {
            this.listOfWayppoints.get(i).init(gc);
        }
        this.airport.init(gc);
        for (i = 0; i < this.listOfExitPoints.size(); ++i) {
            this.listOfExitPoints.get(i).init(gc);
        }
        for (i = 0; i < this.listofEntrypoints.size(); ++i) {
            this.listofEntrypoints.get(i).init(gc);
        }
    }

    public void update(GameContainer gc) {
        ++this.numberOfGameLoopsSinceLastFlightAdded;
        ++this.numberOfGameLoopsSinceLastFlightAirport;
        ++this.numberOfGameLoops;
        if (this.numberOfGameLoops >= this.numberOfGameLoopsWhenDifficultyIncreases) {
            this.increaseDifficulty();
        }
        this.AirportAvailable = this.numberOfGameLoopsSinceLastFlightAirport > 500;
        for (int i = 0; i < this.listOfFlightsInAirspace.size(); ++i) {
            this.listOfFlightsInAirspace.get(i).update();
            if (this.listOfFlightsInAirspace.get(i).getLanding() && this.numberOfGameLoopsSinceLastFlightAirport > 250) {
                this.removeSpecificFlight(i);
                continue;
            }
            if (!this.checkIfFlightHasLeftAirspace(this.getListOfFlights().get(i))) continue;
            this.removeSpecificFlight(i);
        }
        this.separationRules.update(this);
        this.controls.update(gc, this);
    }

    public void render(Graphics g, GameContainer gc) throws SlickException {
        int i;
        for (i = 0; i < this.listOfWayppoints.size(); ++i) {
            this.listOfWayppoints.get(i).render(g, this);
        }
        this.airport.render(g, this);
        for (i = 0; i < this.listOfExitPoints.size(); ++i) {
            this.listOfExitPoints.get(i).render(g, this);
        }
        for (i = 0; i < this.listofEntrypoints.size(); ++i) {
            this.listofEntrypoints.get(i).render(g);
        }
        for (i = 0; i < this.listOfFlightsInAirspace.size(); ++i) {
            this.listOfFlightsInAirspace.get(i).render(g, gc);
        }
        this.separationRules.render(g, gc, this);
        this.controls.render(gc, g);
    }

    public int getMaxNumberOfFlights() {
        return this.maximumNumberOfFlightsInAirspace;
    }

    public int getScore() {
        return this.score;
    }

    public List<Flight> getListOfFlights() {
        return this.listOfFlightsInAirspace;
    }

    public List<Waypoint> getListOfWaypoints() {
        return this.listOfWayppoints;
    }

    public List<EntryPoint> getListOfEntryPoints() {
        return this.listofEntrypoints;
    }

    public List<ExitPoint> getListOfExitPoints() {
        return this.listOfExitPoints;
    }

    public Point getAirport() {
        return this.airport;
    }

    public boolean getAvailableAirport() {
        return this.AirportAvailable;
    }

    public void resetNumberOfGameLoopsSinceLastFlightAirport() {
        this.numberOfGameLoopsSinceLastFlightAirport = 0;
    }

    public void setMaxNumberOfFlights(int maxNumberOfFlights) {
        this.maximumNumberOfFlightsInAirspace = maxNumberOfFlights;
    }

    public boolean addWaypoint(Waypoint waypoint) {
        if (this.listOfWayppoints.contains(waypoint)) {
            return false;
        }
        this.listOfWayppoints.add(waypoint);
        return true;
    }

    public boolean addAirport(Airport airport) {
        return true;
    }

    public boolean addEntryPoint(EntryPoint entrypoint) {
        if (this.listofEntrypoints.contains(entrypoint)) {
            return false;
        }
        this.listofEntrypoints.add(entrypoint);
        return true;
    }

    public boolean addExitPoint(ExitPoint exitpoint) {
        if (this.listOfExitPoints.contains(exitpoint)) {
            return false;
        }
        this.listOfExitPoints.add(exitpoint);
        return true;
    }

    public boolean addFlight(Flight flight) {
        if (this.listOfFlightsInAirspace.contains(flight) && this.listOfFlightsInAirspace.size() > this.maximumNumberOfFlightsInAirspace - 1) {
            return false;
        }
        this.listOfFlightsInAirspace.add(flight);
        return true;
    }

    public void removeSpecificFlight(int flight) {
        if (this.listOfFlightsInAirspace.get(flight).getFlightPlan().getCurrentRoute().size() == 0) {
            this.changeScore(200);
        } else {
            this.changeScore(-200);
        }
        this.listOfFlightsInAirspace.remove(flight);
        if (!this.listOfFlightsInAirspace.contains(this.controls.getSelectedFlight())) {
            this.controls.setSelectedFlight(null);
        }
    }

    public void removeFlightInstance(Flight flight) {
        this.listOfFlightsInAirspace.remove(flight);
        if (!this.listOfFlightsInAirspace.contains(this.controls.getSelectedFlight())) {
            this.controls.setSelectedFlight(null);
        }
    }

    public void removeWaypoint(Waypoint waypoint) {
        this.listOfWayppoints.remove(waypoint);
    }

    public void removeEntryPoint(EntryPoint entrypoint) {
        this.listofEntrypoints.remove(entrypoint);
    }

    public void removeExitPoint(ExitPoint exitpoint) {
        this.listOfExitPoints.remove(exitpoint);
    }

    public SeparationRules getSeparationRules() {
        return this.separationRules;
    }

    public void setListOfEntryPoints(List<EntryPoint> listOfEntryPoints) {
        this.listofEntrypoints = listOfEntryPoints;
    }

    public Controls getControls() {
        return this.controls;
    }

    public void setDifficultyValueOfGame(int i) {
        this.difficultyValueOfGame = i;
    }

    public int getDifficultyValueOfGame() {
        return this.difficultyValueOfGame;
    }

    public int getNumberOfGameLoops() {
        return this.numberOfGameLoops;
    }

    public int getNumberOfGameLoopsWhenDifficultyIncreases() {
        return this.numberOfGameLoopsWhenDifficultyIncreases;
    }
}

