/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.awt.Font;
import logicClasses.Airspace;
import logicClasses.Flight;
import org.lwjgl.input.Mouse;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.gui.TextField;

public class Controls {
    private TrueTypeFont font;
    private TextField headingControlTextBox;
    private TextField turnRightTextBox;
    private TextField turnLeftTextBox;
    private boolean selectingHeadingUsingTextBox = false;
    private boolean mouseHeldDownOnsideButton = false;
    private boolean mouseHeldDownOnFlight = false;
    private boolean headingAlreadyChangedByMouse = false;
    private final int MAXIMUM_ALTITUDE = 9000;
    private final int MINIMUM_ALTITUDE = 1000;
    private final int MAXIMUM_VELOCITY = 400;
    private final int MINIMUM_VELOCITY = 75;
    private Flight selectedFlight = null;
    private String text;
    private Image sideButton;
    private int difficultyValueOfGame;

    public void init(GameContainer gc) throws SlickException {
        Font awtFont = new Font("Courier", 1, 15);
        this.font = new TrueTypeFont(awtFont, false);
        this.turnLeftTextBox = new TextField(gc, this.font, 10, 145, 100, 23);
        this.headingControlTextBox = new TextField(gc, this.font, 10, 195, 100, 23);
        this.turnRightTextBox = new TextField(gc, this.font, 10, 245, 100, 23);
        this.turnLeftTextBox.setMaxLength(3);
        this.turnRightTextBox.setMaxLength(3);
        this.headingControlTextBox.setMaxLength(3);
        this.sideButton = new Image("res/graphics/side_button.png");
    }

    public void handleAndUpdatesideButtons() {
        if (this.mouseHeldDownOnsideButton) {
            return;
        }
        this.mouseHeldDownOnsideButton = true;
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (!this.selectedFlight.getTakenOff() && posX > 10 && posX < 150 && posY < 320 && posY > 300 && Mouse.isButtonDown(0)) {
            this.selectedFlight.TakeOff();
        }
        if (this.selectedFlight.getTakenOff() && !this.selectedFlight.getLanding()) {
            if (posX > 10 && posX < 150 && posY < 320 && posY > 300 && Mouse.isButtonDown(0) && this.selectedFlight.getAirspace().getAvailableAirport() && this.selectedFlight.getCurrentAltitude() >= 1000) {
                this.selectedFlight.LandFlight();
            }
            if (posX > 10 && posX < 150 && posY < 350 && posY > 330 && Mouse.isButtonDown(0)) {
                if (this.selectedFlight.getFlightPlan().getTargetVelocity() < 400.0) {
                    this.selectedFlight.changeVelocity(this.selectedFlight.getFlightPlan().getTargetVelocity() + 25.0);
                }
            } else if (posX > 10 && posX < 150 && posY < 380 && posY > 360 && Mouse.isButtonDown(0) && this.selectedFlight.getFlightPlan().getTargetVelocity() > 75.0) {
                this.selectedFlight.changeVelocity(this.selectedFlight.getFlightPlan().getTargetVelocity() - 25.0);
            }
            if (posX > 10 && posX < 150 && posY < 410 && posY > 390 && Mouse.isButtonDown(0)) {
                if (this.selectedFlight.getTargetAltitude() < 9000) {
                    this.selectedFlight.setTargetAltitude(this.selectedFlight.getTargetAltitude() + 1000);
                }
            } else if (posX > 10 && posX < 150 && posY < 440 && posY > 420 && Mouse.isButtonDown(0) && this.selectedFlight.getTargetAltitude() > 1000) {
                this.selectedFlight.setTargetAltitude(this.selectedFlight.getTargetAltitude() - 1000);
            }
        }
    }

    public void changeModeByClickingOnFlight(Flight nearestFlight) {
        if (this.selectedFlight.getFlightPlan().getChangingPlan()) {
            nearestFlight.getFlightPlan().setChangingPlan(false);
        } else {
            nearestFlight.getFlightPlan().setChangingPlan(true);
        }
    }

    public void checkSelected(int pointX, int pointY, Airspace airspace) {
        if (this.mouseHeldDownOnFlight) {
            return;
        }
        this.mouseHeldDownOnFlight = true;
        if (this.selectedFlight != null && this.selectedFlight.getFlightPlan().getDraggingWaypoint()) {
            return;
        }
        if (airspace.getListOfFlights().size() >= 1) {
            int i;
            double minimumDistanceBetweenFlightAndMouseClick = Math.sqrt(Math.pow((double)pointX - airspace.getListOfFlights().get(0).getX(), 2.0) + Math.pow((double)pointY - airspace.getListOfFlights().get(0).getY(), 2.0));
            Flight nearestFlight = airspace.getListOfFlights().get(0);
            int indexOfNearestFlightInAirspaceListOfFlights = 0;
            for (i = 0; i < airspace.getListOfFlights().size(); ++i) {
                if (!(Math.sqrt(Math.pow((double)pointX - airspace.getListOfFlights().get(i).getX(), 2.0) + Math.pow((double)pointY - airspace.getListOfFlights().get(i).getY(), 2.0)) < minimumDistanceBetweenFlightAndMouseClick)) continue;
                minimumDistanceBetweenFlightAndMouseClick = Math.sqrt(Math.pow((double)pointX - airspace.getListOfFlights().get(i).getX(), 2.0) + Math.pow((double)pointY - airspace.getListOfFlights().get(i).getY(), 2.0));
                nearestFlight = airspace.getListOfFlights().get(i);
                indexOfNearestFlightInAirspaceListOfFlights = i;
            }
            if (minimumDistanceBetweenFlightAndMouseClick <= 50.0) {
                if (nearestFlight == this.selectedFlight) {
                    this.changeModeByClickingOnFlight(nearestFlight);
                }
                nearestFlight.setSelected(true);
                this.setSelectedFlight(nearestFlight);
                for (i = 0; i < airspace.getListOfFlights().size(); ++i) {
                    if (i == indexOfNearestFlightInAirspaceListOfFlights) continue;
                    airspace.getListOfFlights().get(i).setSelected(false);
                    airspace.getListOfFlights().get(i).getFlightPlan().setChangingPlan(false);
                    this.turnLeftTextBox.setText("");
                    this.turnRightTextBox.setText("");
                }
            }
        }
    }

    public void giveHeadingWithMouse(int pointX, int pointY, Airspace airspace) {
        if (this.selectedFlight.getTakenOff() && !this.selectedFlight.getLanding()) {
            if (this.headingAlreadyChangedByMouse) {
                return;
            }
            this.headingAlreadyChangedByMouse = true;
            double distanceBetweenMouseAndPlane = Math.sqrt(Math.pow((double)pointX - this.selectedFlight.getX(), 2.0) + Math.pow((double)pointY - this.selectedFlight.getY(), 2.0));
            if (distanceBetweenMouseAndPlane < 50.0) {
                double deltaY = (double)pointY - this.selectedFlight.getY();
                double deltaX = (double)pointX - this.selectedFlight.getX();
                double angle = Math.toDegrees(Math.atan2(deltaY, deltaX));
                if ((angle += 90.0) < 0.0) {
                    angle += 360.0;
                }
                this.selectedFlight.giveHeading((int)angle);
            }
        }
    }

    public void updateHeadingTextBox(Input input) {
        boolean headingTextBoxHasFocus = this.headingControlTextBox.hasFocus();
        if (headingTextBoxHasFocus) {
            if (!this.selectingHeadingUsingTextBox) {
                this.selectingHeadingUsingTextBox = true;
                this.headingControlTextBox.setText("");
            }
            if (input.isKeyDown(28)) {
                this.text = this.headingControlTextBox.getText();
                this.text = this.text.replaceAll("\\D+", "");
                if (!this.text.isEmpty()) {
                    this.selectedFlight.giveHeading(Integer.valueOf(this.text));
                    this.headingControlTextBox.setFocus(false);
                }
            }
        }
        if (this.selectingHeadingUsingTextBox && !headingTextBoxHasFocus) {
            this.selectingHeadingUsingTextBox = false;
        }
    }

    public void updateTurnLeftTextBox(Input input) {
        boolean turnLeftTextBoxHasFocus = this.turnLeftTextBox.hasFocus();
        if (turnLeftTextBoxHasFocus) {
            if (input.isKeyDown(28)) {
                this.text = this.turnLeftTextBox.getText();
                this.text = this.text.replaceAll("\\D+", "");
                if (!this.text.isEmpty() && Integer.valueOf(this.text) <= 360) {
                    this.selectedFlight.turnFlightLeft(Integer.valueOf(this.text));
                    this.turnLeftTextBox.setText("");
                }
                this.turnLeftTextBox.setFocus(false);
            }
        } else {
            this.turnLeftTextBox.setText("");
        }
    }

    public void updateTurnRightTextBox(Input input) {
        if (this.turnRightTextBox.hasFocus()) {
            if (input.isKeyDown(28)) {
                this.text = this.turnRightTextBox.getText();
                this.text = this.text.replaceAll("\\D+", "");
                if (!this.text.isEmpty() && Integer.valueOf(this.text) <= 360) {
                    this.selectedFlight.turnFlightRight(Integer.valueOf(this.text));
                    this.turnRightTextBox.setText("");
                }
                this.turnRightTextBox.setFocus(false);
            }
        } else {
            this.turnRightTextBox.setText("");
        }
    }

    public void render(GameContainer gc, Graphics g) throws SlickException {
        if (this.selectedFlight != null) {
            this.sideButton.draw(0.0f, 45.0f);
            this.sideButton.draw(0.0f, 75.0f);
            if (!this.selectedFlight.getFlightPlan().getChangingPlan()) {
                g.setColor(Color.lightGray);
                g.drawString("Plan Mode", 10.0f, 45.0f);
                g.setColor(Color.white);
                g.drawString("Navigator Mode", 10.0f, 75.0f);
                if (!this.selectedFlight.getTakenOff()) {
                    g.setColor(Color.white);
                    this.sideButton.draw(0.0f, 300.0f);
                    g.drawString("Take Off", 10.0f, 300.0f);
                } else {
                    g.setColor(Color.white);
                    g.drawString("Turn Left:", 10.0f, 125.0f);
                    this.turnLeftTextBox.render(gc, g);
                    g.drawString("DEG", 114.0f, 150.0f);
                    g.drawString("Target Heading:", 10.0f, 175.0f);
                    this.headingControlTextBox.render(gc, g);
                    g.drawString("DEG", 114.0f, 200.0f);
                    g.drawString("Turn Right:", 10.0f, 225.0f);
                    this.turnRightTextBox.render(gc, g);
                    g.drawString("DEG", 114.0f, 250.0f);
                    this.sideButton.draw(0.0f, 300.0f);
                    if (this.selectedFlight.checkIfAtAirport(this.selectedFlight.getAirspace().getAirport()) && this.selectedFlight.getAirspace().getAvailableAirport() && this.selectedFlight.getAltitude() == 1000 && this.selectedFlight.getFlightPlan().getVelocity() < 100.0) {
                        g.drawString("Land", 10.0f, 300.0f);
                    } else {
                        g.drawString("Cannot land", 10.0f, 300.0f);
                    }
                    this.sideButton.draw(0.0f, 330.0f);
                    if (this.selectedFlight.getFlightPlan().getTargetVelocity() < 400.0) {
                        g.drawString("Accelerate to " + Math.round(this.selectedFlight.getFlightPlan().getTargetVelocity() + 25.0), 10.0f, 330.0f);
                    } else {
                        g.drawString("At max speed", 10.0f, 330.0f);
                    }
                    this.sideButton.draw(0.0f, 360.0f);
                    if (this.selectedFlight.getFlightPlan().getTargetVelocity() > 75.0) {
                        g.drawString("Decelerate to " + Math.round(this.selectedFlight.getFlightPlan().getTargetVelocity() - 25.0), 10.0f, 360.0f);
                    } else {
                        g.drawString("At min speed", 10.0f, 360.0f);
                    }
                    this.sideButton.draw(0.0f, 390.0f);
                    if (this.selectedFlight.getTargetAltitude() < 9000) {
                        g.drawString("Climb to " + (this.selectedFlight.getTargetAltitude() + 1000), 10.0f, 390.0f);
                    } else {
                        g.drawString("At max altitude", 10.0f, 390.0f);
                    }
                    this.sideButton.draw(0.0f, 420.0f);
                    if (this.selectedFlight.getTargetAltitude() > 1000) {
                        g.drawString("Descend to " + (this.selectedFlight.getTargetAltitude() - 1000), 10.0f, 420.0f);
                    } else {
                        g.drawString("At min altitude", 10.0f, 420.0f);
                    }
                }
            } else {
                g.setColor(Color.white);
                g.drawString("Plan Mode", 10.0f, 45.0f);
                g.setColor(Color.lightGray);
                g.drawString("Navigator Mode", 10.0f, 75.0f);
            }
        }
    }

    public void update(GameContainer gc, Airspace airspace) {
        Input input = gc.getInput();
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (this.selectedFlight != null) {
            if (!this.selectedFlight.getFlightPlan().getChangingPlan()) {
                if (posX > 10 && posX < 150 && posY < 65 && posY > 45 && Mouse.isButtonDown(0)) {
                    this.selectedFlight.getFlightPlan().setChangingPlan(true);
                }
                this.handleAndUpdatesideButtons();
                if (this.selectedFlight.getTakenOff()) {
                    if (Mouse.isButtonDown(1)) {
                        this.giveHeadingWithMouse(posX, posY, airspace);
                    }
                    this.updateHeadingTextBox(input);
                    this.updateTurnLeftTextBox(input);
                    this.updateTurnRightTextBox(input);
                    if (!this.headingControlTextBox.hasFocus()) {
                        this.getHeadingControlTB().setText(String.valueOf(Math.round(this.selectedFlight.getTargetHeading())));
                    }
                    if (input.isKeyPressed(200) && this.selectedFlight.getTargetAltitude() < 9000) {
                        this.selectedFlight.setTargetAltitude(this.selectedFlight.getTargetAltitude() + 1000);
                    }
                    if (input.isKeyPressed(208) && this.selectedFlight.getTargetAltitude() > 1000) {
                        this.selectedFlight.setTargetAltitude(this.selectedFlight.getTargetAltitude() - 1000);
                    }
                }
            } else if (posX > 10 && posX < 150 && posY < 95 && posY > 75 && Mouse.isButtonDown(0)) {
                this.selectedFlight.getFlightPlan().setChangingPlan(false);
            }
        }
        if (Mouse.isButtonDown(0)) {
            this.checkSelected(posX, posY, airspace);
        }
        if (!Mouse.isButtonDown(0)) {
            this.mouseHeldDownOnFlight = false;
            this.mouseHeldDownOnsideButton = false;
        }
        if (!Mouse.isButtonDown(1)) {
            this.headingAlreadyChangedByMouse = false;
        }
    }

    public void setSelectedFlight(Flight flight1) {
        this.selectedFlight = flight1;
    }

    public TextField getHeadingControlTB() {
        return this.headingControlTextBox;
    }

    public Flight getSelectedFlight() {
        return this.selectedFlight;
    }

    public void setDifficultyValueOfGame(int value) {
        this.difficultyValueOfGame = value;
    }
}

