/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.util.Random;
import logicClasses.Airspace;
import logicClasses.FlightPlan;
import logicClasses.Point;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;

public class Flight {
    private double x = 0.0;
    private double y = 0.0;
    private double currentHeading;
    private double targetHeading;
    private int currentAltitude;
    private int targetAltitude = 0;
    private int flightNumber;
    private boolean turningRight;
    private boolean turningLeft;
    private boolean landing;
    private boolean takenOff;
    private boolean selected;
    private String flightName;
    private FlightPlan flightPlan;
    private Image regularFlightImage;
    private Image selectedFlightInformationBackgroundImage;
    private Image slowFlightImage;
    private Image fastFlightImage;
    private Image shadowImage;
    private Airspace airspace;

    public Flight(Airspace airspace, int entry) {
        this.currentAltitude = this.generateAltitude(entry);
        this.targetHeading = 0.0;
        this.currentHeading = 0.0;
        this.turningRight = false;
        this.turningLeft = false;
        this.landing = false;
        this.takenOff = this.currentAltitude != 0;
        this.airspace = airspace;
        this.flightPlan = new FlightPlan(airspace, this, entry);
        this.selected = false;
    }

    public int generateAltitude(int entry) {
        if (entry == 4) {
            return 0;
        }
        Random rand = new Random();
        int check = rand.nextInt(3);
        switch (check) {
            case 0: {
                return 5000;
            }
            case 1: {
                return 6000;
            }
            case 2: {
                return 7000;
            }
        }
        return 9000;
    }

    public double calculateHeadingToFirstWaypoint(double desX, double desY) {
        double deltaY = desY - this.y;
        double deltaX = desX - this.x;
        double angle = Math.toDegrees(Math.atan2(deltaY, deltaX));
        if ((angle += 90.0) < 0.0) {
            angle += 360.0;
        }
        return angle;
    }

    public void LandFlight() {
        if (this.currentAltitude <= 1000 && this.flightPlan.getVelocity() < 100.0 && this.checkIfAtAirport(this.airspace.getAirport()) && this.airspace.getAvailableAirport() && this.takenOff) {
            this.landing = true;
            this.getFlightPlan().setTargetVelocity(0.0);
            this.setTargetAltitude(0);
            this.airspace.resetNumberOfGameLoopsSinceLastFlightAirport();
        }
    }

    public void TakeOff() {
        if (!this.takenOff) {
            this.takenOff = true;
            this.flightPlan.setTargetVelocity(100.0);
            this.setTargetAltitude(1000);
        }
    }

    public void turnFlightLeft(int degreeTurnedBy) {
        this.turningRight = false;
        this.turningLeft = true;
        this.targetHeading = Math.round(this.currentHeading) - (long)degreeTurnedBy;
        if (this.targetHeading < 0.0) {
            this.targetHeading = 360.0 + this.targetHeading;
        }
    }

    public void turnFlightRight(int degreeTurnedBy) {
        this.turningLeft = false;
        this.turningRight = true;
        this.targetHeading = Math.round(this.currentHeading) + (long)degreeTurnedBy;
        if (this.targetHeading >= 360.0) {
            this.targetHeading -= 360.0;
        }
    }

    public void changeVelocity(double newTarget) {
        if (newTarget <= 400.0 && newTarget >= 0.0) {
            this.flightPlan.setTargetVelocity(newTarget);
        }
    }

    public void giveHeading(int newHeading) {
        this.turningRight = false;
        this.turningLeft = false;
        this.targetHeading = newHeading %= 360;
    }

    public boolean checkIfFlightAtWaypoint(Point waypoint) {
        if (Math.abs(Math.round(this.x) - Math.round(waypoint.getX())) <= 15L && Math.abs(Math.round(this.y) - Math.round(waypoint.getY())) <= 15L) {
            this.airspace.changeScore(100);
            return true;
        }
        return false;
    }

    public boolean checkIfAtAirport(Point airport) {
        return Math.abs(Math.round(this.x) - Math.round(airport.getX())) <= 70L && Math.abs(Math.round(this.y) - Math.round(airport.getY())) <= 15L;
    }

    public void drawFlight(Graphics g, GameContainer gc) {
        g.setColor(Color.white);
        g.setWorldClip(150.0f, 0.0f, 1200.0f, 600.0f);
        float shadowScale = (float)(36 - this.currentAltitude / 1000) / 10.0f;
        this.shadowImage.setRotation((int)this.currentHeading);
        this.shadowImage.draw((float)((int)this.x - 35), (float)((int)this.y), shadowScale);
        if (this.flightPlan.getVelocity() <= 200.0) {
            this.slowFlightImage.setRotation((int)this.currentHeading);
            this.slowFlightImage.draw((int)this.x - 10, (int)this.y - 10);
        } else if (this.flightPlan.getVelocity() > 200.0 && this.flightPlan.getVelocity() < 300.0) {
            this.regularFlightImage.setRotation((int)this.currentHeading);
            this.regularFlightImage.draw((int)this.x - 10, (int)this.y - 10);
        } else {
            this.fastFlightImage.setRotation((int)this.currentHeading);
            this.fastFlightImage.draw((int)this.x - 10, (int)this.y - 10);
        }
        g.drawOval((int)this.x - 50, (int)this.y - 50, 100.0f, 100.0f);
        if (this.selected) {
            g.setColor(Color.white);
            g.drawString(this.flightName, (int)this.x - 24, (int)this.y - 44);
            g.drawString(Math.round(this.currentAltitude) + "ft", (int)this.x - 25, (int)this.y + 10);
            g.drawString(Math.round(this.currentHeading) + "\u00b0", (int)this.x - 13, (int)this.y + 25);
            if (this.flightPlan.getCurrentRoute().size() > 0) {
                g.drawString("Aim: " + this.flightPlan.getPointByIndex(0).getPointRef(), (int)this.x - 22, (int)this.y - 28);
            }
        } else {
            g.setColor(Color.lightGray);
            g.drawString(this.flightName, (int)this.x - 24, (int)this.y - 44);
            g.drawString(Math.round(this.currentAltitude) + "ft", (int)this.x - 25, (int)this.y + 10);
            if (this.flightPlan.getCurrentRoute().size() > 0) {
                g.drawString("Aim: " + this.flightPlan.getPointByIndex(0).getPointRef(), (int)this.x - 22, (int)this.y - 28);
            }
            g.drawOval((int)this.x - 50, (int)this.y - 50, 100.0f, 100.0f);
        }
        g.setWorldClip(0.0f, 0.0f, 1200.0f, 600.0f);
    }

    public void drawSelectedFlightInformation(Graphics g, GameContainer gc) {
        this.selectedFlightInformationBackgroundImage.draw(0.0f, 450.0f);
        g.setColor(Color.white);
        g.drawString(this.flightName, 10.0f, 460.0f);
        g.drawString("Plan: ", 10.0f, 480.0f);
        String plan = "";
        for (int i = 0; i < this.flightPlan.getCurrentRoute().size(); ++i) {
            plan = plan + this.flightPlan.getCurrentRoute().get(i).getPointRef() + ", ";
        }
        g.setColor(Color.white);
        g.drawString(plan, 10.0f, 500.0f);
        g.drawString(Math.round(this.currentAltitude) + "ft", 10.0f, 520.0f);
        g.drawString(Math.round(this.currentHeading) + "\u00b0", 10.0f, 540.0f);
        g.drawString(Math.round(this.getFlightPlan().getVelocity()) + "mph", 10.0f, 560.0f);
    }

    public void updateXYCoordinates() {
        double velocity = this.flightPlan.getVelocity() / 1000.0;
        this.x += velocity * Math.sin(Math.toRadians(this.currentHeading));
        this.y -= velocity * Math.cos(Math.toRadians(this.currentHeading));
    }

    public void updateVelocity() {
        if (this.flightPlan.getVelocity() > this.flightPlan.getTargetVelocity()) {
            this.flightPlan.setVelocity(this.flightPlan.getVelocity() - 0.25);
        } else if (this.flightPlan.getVelocity() < this.flightPlan.getTargetVelocity()) {
            this.flightPlan.setVelocity(this.flightPlan.getVelocity() + 0.25);
        }
    }

    public void updateAltitude() {
        if (this.currentAltitude > this.targetAltitude) {
            this.currentAltitude -= 4;
        } else if (this.currentAltitude < this.targetAltitude) {
            this.currentAltitude += 4;
        }
    }

    public void updateCurrentHeading() {
        double rate = 0.5;
        if (Math.round(this.targetHeading) != Math.round(this.currentHeading)) {
            if (!this.turningRight && !this.turningLeft) {
                if (Math.abs(this.targetHeading - this.currentHeading) == 180.0) {
                    this.turningRight = true;
                } else if (this.currentHeading + 180.0 <= 359.0) {
                    if (this.targetHeading < this.currentHeading + 180.0 && this.targetHeading > this.currentHeading) {
                        this.turningRight = true;
                    } else {
                        this.turningLeft = true;
                    }
                } else if (this.targetHeading > this.currentHeading - 180.0 && this.targetHeading < this.currentHeading) {
                    this.turningLeft = true;
                } else {
                    this.turningRight = true;
                }
            }
            if (this.turningRight) {
                this.currentHeading += rate;
                if (Math.round(this.currentHeading) >= 360L && this.targetHeading != 360.0) {
                    this.currentHeading = 0.0;
                }
            }
            if (this.turningLeft) {
                this.currentHeading -= rate;
                if (Math.round(this.currentHeading) <= 0L && this.targetHeading != 0.0) {
                    this.currentHeading = 360.0;
                }
            }
        }
    }

    public void init(GameContainer gc) throws SlickException {
        this.regularFlightImage = new Image("res/graphics/flight.png");
        this.shadowImage = new Image("res/graphics/flight_shadow.png");
        this.slowFlightImage = new Image("res/graphics/flight_slow.png");
        this.fastFlightImage = new Image("res/graphics/flight_fast.png");
        this.selectedFlightInformationBackgroundImage = new Image("res/graphics/selected_flight.jpg");
    }

    public void update() {
        this.updateCurrentHeading();
        this.updateXYCoordinates();
        this.updateAltitude();
        this.updateVelocity();
        this.flightPlan.update();
    }

    public void render(Graphics g, GameContainer gc) throws SlickException {
        this.drawFlight(g, gc);
        this.flightPlan.render(g, gc);
        if (this.selected) {
            this.drawSelectedFlightInformation(g, gc);
        }
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getCurrentHeading() {
        return this.currentHeading;
    }

    public void setCurrentHeading(double currentHeading) {
        this.currentHeading = currentHeading;
    }

    public double getTargetHeading() {
        return this.targetHeading;
    }

    public void setTargetHeading(double targetHeading) {
        this.targetHeading = targetHeading;
    }

    public int getTargetAltitude() {
        return this.targetAltitude;
    }

    public void setTargetAltitude(int targetAltitude) {
        this.targetAltitude = targetAltitude;
    }

    public int getAltitude() {
        return this.currentAltitude;
    }

    public void setAltitude(int altitude) {
        this.currentAltitude = altitude;
    }

    public boolean getTurningRight() {
        return this.turningRight;
    }

    public boolean getLanding() {
        return this.landing;
    }

    public boolean getTakenOff() {
        return this.takenOff;
    }

    public void setTurningRight(boolean turningRight) {
        this.turningRight = turningRight;
    }

    public boolean getTurningLeft() {
        return this.turningLeft;
    }

    public void setTurningLeft(boolean turningLeft) {
        this.turningLeft = turningLeft;
    }

    public void setFlightNum(int i) {
        this.flightNumber = i;
    }

    public int getFlightNum() {
        return this.flightNumber;
    }

    public String getFlightName() {
        return this.flightName;
    }

    public void setFlightName(String flightName) {
        this.flightName = flightName;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public String toString() {
        return "X: " + this.x + " Y: " + this.y + " Flight Number: " + this.flightNumber;
    }

    public int getCurrentAltitude() {
        return this.currentAltitude;
    }

    public void setCurrentAltitude(int currentAltitude) {
        this.currentAltitude = currentAltitude;
    }

    public FlightPlan getFlightPlan() {
        return this.flightPlan;
    }

    public Airspace getAirspace() {
        return this.airspace;
    }

    public boolean getSelected() {
        return this.selected;
    }
}

