/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.util.ArrayList;
import java.util.Random;
import logicClasses.Airspace;
import logicClasses.EntryPoint;
import logicClasses.ExitPoint;
import logicClasses.Flight;
import logicClasses.Point;
import logicClasses.Waypoint;
import org.lwjgl.input.Mouse;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public class FlightPlan {
    private ArrayList<Point> currentRoute = new ArrayList();
    private ArrayList<Point> waypointsAlreadyVisited;
    private double velocity;
    private double targetVelocity;
    private Flight flight;
    private Point waypointMouseIsOver;
    private Point waypointClicked;
    private boolean changingPlan;
    private boolean draggingWaypoint;
    private EntryPoint entryPoint;

    public FlightPlan(Airspace airspace, Flight flight, int entry) {
        this.flight = flight;
        this.targetVelocity = this.velocity = (double)this.generateVelocity();
        this.entryPoint = this.generateEntryPoint(airspace, entry);
        this.currentRoute = this.buildRoute(airspace, this.entryPoint, entry);
        this.waypointsAlreadyVisited = new ArrayList();
        this.changingPlan = false;
        this.draggingWaypoint = false;
    }

    public EntryPoint generateEntryPoint(Airspace airspace, int entry) {
        Random rand = new Random();
        int randomNumber = rand.nextInt(3);
        if (entry == 4) {
            this.flight.setX(airspace.getAirport().getX());
            this.flight.setY(airspace.getAirport().getY());
        } else {
            this.flight.setX(airspace.getListOfEntryPoints().get(randomNumber).getX());
            this.flight.setY(airspace.getListOfEntryPoints().get(randomNumber).getY());
        }
        return airspace.getListOfEntryPoints().get(randomNumber);
    }

    public ArrayList<Point> buildRoute(Airspace airspace, EntryPoint entryPoint, int entry) {
        ArrayList<Point> tempRoute;
        block13: {
            int i;
            tempRoute = new ArrayList<Point>();
            ArrayList<Waypoint> tempListOfWaypoints = new ArrayList<Waypoint>();
            ArrayList<ExitPoint> tempListOfExitPoints = new ArrayList<ExitPoint>();
            Boolean exitpointAdded = false;
            if (airspace.getListOfWaypoints().isEmpty() || airspace.getListOfExitPoints().isEmpty()) break block13;
            Random rand = new Random();
            for (i = 0; i < airspace.getListOfWaypoints().size(); ++i) {
                tempListOfWaypoints.add(airspace.getListOfWaypoints().get(i));
            }
            for (i = 0; i < airspace.getListOfExitPoints().size(); ++i) {
                tempListOfExitPoints.add(airspace.getListOfExitPoints().get(i));
            }
            int pointsInPlan = rand.nextInt(3) + 3;
            for (int i2 = 0; i2 < pointsInPlan - 1; ++i2) {
                int waypointIndex = rand.nextInt(tempListOfWaypoints.size());
                tempRoute.add((Point)tempListOfWaypoints.get(waypointIndex));
                tempListOfWaypoints.remove(waypointIndex);
            }
            if (entry != 4) {
                int choice = rand.nextInt(5);
                if (choice != 4) {
                    int ExitPointIndex = rand.nextInt(tempListOfExitPoints.size());
                    while (!exitpointAdded.booleanValue()) {
                        if (this.entryPoint.getY() == ((Point)tempListOfExitPoints.get(ExitPointIndex)).getY()) {
                            tempListOfExitPoints.remove(ExitPointIndex);
                            ExitPointIndex = rand.nextInt(tempListOfExitPoints.size());
                            continue;
                        }
                        if (this.entryPoint.getX() == ((Point)tempListOfExitPoints.get(ExitPointIndex)).getX()) {
                            tempListOfExitPoints.remove(ExitPointIndex);
                            ExitPointIndex = rand.nextInt(tempListOfExitPoints.size());
                            continue;
                        }
                        tempRoute.add((Point)tempListOfExitPoints.get(ExitPointIndex));
                        exitpointAdded = true;
                    }
                } else {
                    tempRoute.add(airspace.getAirport());
                }
            } else {
                int ExitPointIndex = rand.nextInt(tempListOfExitPoints.size());
                while (!exitpointAdded.booleanValue()) {
                    if (this.entryPoint.getY() == ((Point)tempListOfExitPoints.get(ExitPointIndex)).getY()) {
                        tempListOfExitPoints.remove(ExitPointIndex);
                        ExitPointIndex = rand.nextInt(tempListOfExitPoints.size());
                        continue;
                    }
                    if (this.entryPoint.getX() == ((Point)tempListOfExitPoints.get(ExitPointIndex)).getX()) {
                        tempListOfExitPoints.remove(ExitPointIndex);
                        ExitPointIndex = rand.nextInt(tempListOfExitPoints.size());
                        continue;
                    }
                    tempRoute.add((Point)tempListOfExitPoints.get(ExitPointIndex));
                    exitpointAdded = true;
                }
            }
        }
        return tempRoute;
    }

    public int generateVelocity() {
        Random rand = new Random();
        return (rand.nextInt(12) + 4) * 25;
    }

    private boolean isMouseOnWaypoint() {
        int mouseX = Mouse.getX();
        int mouseY = Mouse.getY();
        mouseY = 600 - mouseY;
        if (this.getCurrentRoute().isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.flight.getAirspace().getListOfWaypoints().size(); ++i) {
            if (Math.abs((long)Math.round(mouseX) - Math.round(this.flight.getAirspace().getListOfWaypoints().get(i).getX())) > 15L || Math.abs((long)Math.round(mouseY) - Math.round(this.flight.getAirspace().getListOfWaypoints().get(i).getY())) > 15L) continue;
            this.waypointMouseIsOver = this.flight.getAirspace().getListOfWaypoints().get(i);
            return true;
        }
        this.waypointMouseIsOver = null;
        return false;
    }

    public void updateFlightPlan() {
        if (this.currentRoute.size() > 0 && this.flight.checkIfFlightAtWaypoint(this.currentRoute.get(0))) {
            this.waypointsAlreadyVisited.add(this.currentRoute.get(0));
            this.currentRoute.remove(0);
        }
    }

    public void changeFlightPlan() {
        block6: {
            boolean mouseOverWaypoint;
            block7: {
                if (!this.flight.getSelected() || this.currentRoute.size() <= 0) break block6;
                mouseOverWaypoint = this.isMouseOnWaypoint();
                if (this.draggingWaypoint) break block7;
                if (!mouseOverWaypoint || !Mouse.isButtonDown(0)) break block6;
                this.waypointClicked = this.waypointMouseIsOver;
                this.draggingWaypoint = true;
                break block6;
            }
            if (this.draggingWaypoint) {
                if (!Mouse.isButtonDown(0) && !mouseOverWaypoint) {
                    this.waypointClicked = null;
                    this.draggingWaypoint = false;
                } else if (!Mouse.isButtonDown(0) && mouseOverWaypoint) {
                    for (int i = 0; i < this.currentRoute.size(); ++i) {
                        if (this.waypointClicked == this.currentRoute.get(i) && !this.currentRoute.contains(this.waypointMouseIsOver) && !this.waypointsAlreadyVisited.contains(this.waypointMouseIsOver)) {
                            this.currentRoute.remove(i);
                            this.currentRoute.add(i, this.waypointMouseIsOver);
                            this.waypointClicked = null;
                            this.draggingWaypoint = false;
                            continue;
                        }
                        if (this.waypointClicked != this.currentRoute.get(i) || !this.currentRoute.contains(this.waypointMouseIsOver) && !this.waypointsAlreadyVisited.contains(this.waypointMouseIsOver)) continue;
                        this.waypointClicked = null;
                        this.draggingWaypoint = false;
                        break;
                    }
                }
            }
        }
    }

    public void drawFlightsPlan(Graphics g, GameContainer gc) {
        block6: {
            block7: {
                if (this.currentRoute.size() <= 0) break block6;
                g.setColor(Color.cyan);
                if (this.draggingWaypoint) break block7;
                for (int i = 1; i < this.currentRoute.size(); ++i) {
                    g.drawLine((float)this.currentRoute.get(i).getX(), (float)this.currentRoute.get(i).getY(), (float)this.currentRoute.get(i - 1).getX(), (float)this.currentRoute.get(i - 1).getY());
                }
                break block6;
            }
            if (!this.draggingWaypoint) break block6;
            for (int i = 1; i < this.currentRoute.size(); ++i) {
                if (i == 1) {
                    if (this.waypointClicked == this.currentRoute.get(0)) {
                        g.drawLine(Mouse.getX(), 600 - Mouse.getY(), (float)this.currentRoute.get(1).getX(), (float)this.currentRoute.get(1).getY());
                        continue;
                    }
                    if (this.waypointClicked == this.currentRoute.get(1)) {
                        g.drawLine((float)this.currentRoute.get(i + 1).getX(), (float)this.currentRoute.get(i + 1).getY(), Mouse.getX(), 600 - Mouse.getY());
                        g.drawLine((float)this.currentRoute.get(i - 1).getX(), (float)this.currentRoute.get(i - 1).getY(), Mouse.getX(), 600 - Mouse.getY());
                        ++i;
                        continue;
                    }
                    g.drawLine((float)this.currentRoute.get(i).getX(), (float)this.currentRoute.get(i).getY(), (float)this.currentRoute.get(i - 1).getX(), (float)this.currentRoute.get(i - 1).getY());
                    continue;
                }
                if (this.waypointClicked == this.currentRoute.get(i)) {
                    g.drawLine((float)this.currentRoute.get(i + 1).getX(), (float)this.currentRoute.get(i + 1).getY(), Mouse.getX(), 600 - Mouse.getY());
                    g.drawLine((float)this.currentRoute.get(i - 1).getX(), (float)this.currentRoute.get(i - 1).getY(), Mouse.getX(), 600 - Mouse.getY());
                    ++i;
                    continue;
                }
                g.drawLine((float)this.currentRoute.get(i).getX(), (float)this.currentRoute.get(i).getY(), (float)this.currentRoute.get(i - 1).getX(), (float)this.currentRoute.get(i - 1).getY());
            }
        }
    }

    public void markUnavailableWaypoints(Graphics g, GameContainer gc) {
        for (int i = 0; i < this.waypointsAlreadyVisited.size(); ++i) {
            g.drawLine((float)this.waypointsAlreadyVisited.get(i).getX() - 14.0f, (float)this.waypointsAlreadyVisited.get(i).getY() - 14.0f, (float)this.waypointsAlreadyVisited.get(i).getX() + 14.0f, (float)this.waypointsAlreadyVisited.get(i).getY() + 14.0f);
            g.drawLine((float)this.waypointsAlreadyVisited.get(i).getX() + 14.0f, (float)this.waypointsAlreadyVisited.get(i).getY() - 14.0f, (float)this.waypointsAlreadyVisited.get(i).getX() - 14.0f, (float)this.waypointsAlreadyVisited.get(i).getY() + 14.0f);
        }
    }

    public void update() {
        this.updateFlightPlan();
        if (this.changingPlan) {
            this.changeFlightPlan();
        }
    }

    public void render(Graphics g, GameContainer gc) throws SlickException {
        if (this.flight.getSelected() && this.changingPlan) {
            this.drawFlightsPlan(g, gc);
            this.markUnavailableWaypoints(g, gc);
        }
    }

    public void setVelocity(double newVelocity) {
        this.velocity = newVelocity;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public double getTargetVelocity() {
        return this.targetVelocity;
    }

    public void setTargetVelocity(double target) {
        this.targetVelocity = target;
    }

    public ArrayList<Point> getCurrentRoute() {
        return this.currentRoute;
    }

    public Point getPointByIndex(int i) {
        return this.currentRoute.get(i);
    }

    public boolean getChangingPlan() {
        return this.changingPlan;
    }

    public void setChangingPlan(boolean bool) {
        this.changingPlan = bool;
    }

    public boolean getDraggingWaypoint() {
        return this.draggingWaypoint;
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public String toString() {
        String returnString = "";
        for (int i = 0; i < this.currentRoute.size(); ++i) {
            returnString = returnString + "Point " + i + ": ";
            returnString = returnString + this.currentRoute.get(i).getX();
            returnString = returnString + ", ";
            returnString = returnString + this.currentRoute.get(i).getY();
            returnString = returnString + " | ";
        }
        return returnString;
    }
}

