/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import logicClasses.Airspace;
import logicClasses.Flight;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;

public class SeparationRules {
    private int warningLateralSeparation = 100;
    private int warningVerticalSeparation = 999;
    private int gameOverLateralSeparation;
    private int gameOverVerticalSeparation;
    private boolean gameOverViolation = false;

    public SeparationRules(int difficultyVal) {
        if (difficultyVal == 1) {
            this.gameOverLateralSeparation = 30;
            this.gameOverVerticalSeparation = 200;
        }
        if (difficultyVal == 2) {
            this.gameOverLateralSeparation = 60;
            this.gameOverVerticalSeparation = 350;
        }
        if (difficultyVal == 3) {
            this.gameOverLateralSeparation = 90;
            this.gameOverVerticalSeparation = 500;
        }
    }

    public double lateralDistanceBetweenFlights(Flight flight1, Flight flight2) {
        return Math.sqrt(Math.pow(flight1.getX() - flight2.getX(), 2.0) + Math.pow(flight1.getY() - flight2.getY(), 2.0));
    }

    public int verticalDistanceBetweenFlights(Flight flight1, Flight flight2) {
        return Math.abs(flight1.getAltitude() - flight2.getAltitude());
    }

    public void checkViolation(Airspace airspace) {
        for (int i = 0; i < airspace.getListOfFlights().size(); ++i) {
            for (int j = i + 1; j < airspace.getListOfFlights().size(); ++j) {
                if (!(this.lateralDistanceBetweenFlights(airspace.getListOfFlights().get(i), airspace.getListOfFlights().get(j)) < (double)this.gameOverLateralSeparation) || this.verticalDistanceBetweenFlights(airspace.getListOfFlights().get(i), airspace.getListOfFlights().get(j)) >= this.gameOverVerticalSeparation) continue;
                System.out.print(airspace.getListOfFlights().get(i));
                System.out.print(airspace.getListOfFlights().get(j));
                this.gameOverViolation = true;
            }
        }
    }

    public void render(Graphics g, GameContainer gc, Airspace airspace) {
        for (int i = 0; i < airspace.getListOfFlights().size(); ++i) {
            for (int j = i + 1; j < airspace.getListOfFlights().size(); ++j) {
                if (!(this.lateralDistanceBetweenFlights(airspace.getListOfFlights().get(i), airspace.getListOfFlights().get(j)) <= (double)this.getWarningLateralSeparation()) || this.verticalDistanceBetweenFlights(airspace.getListOfFlights().get(i), airspace.getListOfFlights().get(j)) > this.getWarningVerticalSeparation()) continue;
                float f1x = (float)airspace.getListOfFlights().get(i).getX();
                float f1y = (float)airspace.getListOfFlights().get(i).getY();
                float f2x = (float)airspace.getListOfFlights().get(j).getX();
                float f2y = (float)airspace.getListOfFlights().get(j).getY();
                g.setColor(Color.red);
                g.setLineWidth(2.0f);
                g.drawLine(f1x, f1y, f2x, f2y);
                g.setLineWidth(1.0f);
            }
        }
    }

    public void update(Airspace airspace) {
        this.checkViolation(airspace);
    }

    public void setGameOverLateralSeparation(int lateralSeparation) {
        this.gameOverLateralSeparation = lateralSeparation;
    }

    public void setGameOverVerticalSeparation(int verticalSeparation) {
        this.gameOverVerticalSeparation = verticalSeparation;
    }

    public int getGameOverLateralSeparation() {
        return this.gameOverLateralSeparation;
    }

    public int getGameOverVerticalSeparation() {
        return this.gameOverVerticalSeparation;
    }

    public void setGameOverViolation(boolean gameOverViolation) {
        this.gameOverViolation = gameOverViolation;
    }

    public int getWarningLateralSeparation() {
        return this.warningLateralSeparation;
    }

    public int getWarningVerticalSeparation() {
        return this.warningVerticalSeparation;
    }

    public boolean getGameOverViolation() {
        return this.gameOverViolation;
    }
}

