/*
 * Decompiled with CFR 0.152.
 */
package states;

import org.lwjgl.input.Mouse;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class ControlsState
extends BasicGameState {
    private int stateID;
    private Image menuBackground;
    private static AngelCodeFont titleFont;
    private static AngelCodeFont bodyFont;
    private static AngelCodeFont smallButtonFont;
    private String backString;
    private int backStringHeight;
    private int backStringWidth;
    private boolean mouseBeenReleased = false;

    public ControlsState(int state) {
        this.stateID = state;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.menuBackground = new Image("res/graphics/menu_background.png");
        try {
            titleFont = new AngelCodeFont("res/fonts/fsb60.fnt", "res/fonts/fsb60.png");
            bodyFont = new AngelCodeFont("res/fonts/fsb20.fnt", "res/fonts/fsb20.png");
            smallButtonFont = new AngelCodeFont("res/fonts/fsb30.fnt", "res/fonts/fsb30.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        this.menuBackground.draw(0.0f, 0.0f);
        titleFont.drawString(16.0f, 10.0f, "Help", Color.lightGray);
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        String line1 = "The aim of the game is to send each flight to each of";
        String line2 = "the waypoints listed on its flight plan, while avoiding";
        String line3 = "collisions with other aircraft.";
        String line4 = "Flights can be selected by left-clicking on them.";
        String line5 = "Flights operate in either Navigator Mode or Plan Mode.";
        String line6 = "You can switch between these two modes using the";
        String line7 = "buttons in the left-hand column or by left-clicking on an";
        String line8 = "already-selected flight.";
        String line9 = "In Navigator Mode, the selected flight's altitude, speed and heading";
        String line10 = "can be adjusted using the buttons in the left-hand column. Flights can";
        String line11 = "also be told to take-off or land when in the vicinity of an airport.";
        String line12 = "It is also possible to adjust a flight's altitude using the up and down";
        String line13 = "arrow keys and to change headings by right-clicking within the circle";
        String line14 = "surrounding the currently active flight.";
        String line15 = "In Plan Mode the only possible interaction is to change the current";
        String line16 = "flight's flight plan by dragging from one waypoint to another.";
        bodyFont.drawString(20.0f, 100.0f, line1, Color.lightGray);
        bodyFont.drawString(20.0f, 120.0f, line2, Color.lightGray);
        bodyFont.drawString(20.0f, 140.0f, line3, Color.lightGray);
        bodyFont.drawString(20.0f, 180.0f, line4, Color.lightGray);
        bodyFont.drawString(20.0f, 220.0f, line5, Color.lightGray);
        bodyFont.drawString(20.0f, 240.0f, line6, Color.lightGray);
        bodyFont.drawString(20.0f, 260.0f, line7, Color.lightGray);
        bodyFont.drawString(20.0f, 280.0f, line8, Color.lightGray);
        bodyFont.drawString(20.0f, 320.0f, line9, Color.lightGray);
        bodyFont.drawString(20.0f, 340.0f, line10, Color.lightGray);
        bodyFont.drawString(20.0f, 360.0f, line11, Color.lightGray);
        bodyFont.drawString(20.0f, 400.0f, line12, Color.lightGray);
        bodyFont.drawString(20.0f, 420.0f, line13, Color.lightGray);
        bodyFont.drawString(20.0f, 440.0f, line14, Color.lightGray);
        bodyFont.drawString(20.0f, 480.0f, line15, Color.lightGray);
        bodyFont.drawString(20.0f, 500.0f, line16, Color.lightGray);
        this.backString = "Menu";
        this.backStringWidth = smallButtonFont.getWidth(this.backString);
        this.backStringHeight = smallButtonFont.getHeight(this.backString);
        if (posX >= 20 && posX <= 20 + this.backStringWidth && posY >= 550 && posY <= 550 + this.backStringHeight) {
            smallButtonFont.drawString(20.0f, 550.0f, this.backString, Color.white);
        } else {
            smallButtonFont.drawString(20.0f, 550.0f, this.backString, Color.lightGray);
        }
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (!this.mouseBeenReleased && !Mouse.isButtonDown(0)) {
            this.mouseBeenReleased = true;
        }
        if (posX >= 20 && posX <= 20 + this.backStringWidth && posY >= 550 && posY <= 550 + this.backStringHeight && Mouse.isButtonDown(0) && this.mouseBeenReleased) {
            this.mouseBeenReleased = false;
            sbg.enterState(0);
        }
    }

    @Override
    public int getID() {
        return this.stateID;
    }
}

