/*
 * Decompiled with CFR 0.152.
 */
package states;

import org.lwjgl.input.Mouse;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class GameOverState
extends BasicGameState {
    private int stateID;
    private Image menuBackground;
    public static AngelCodeFont titleFont;
    public static AngelCodeFont smallButtonFont;
    private String againString;
    private String menuString;
    private int againStringWidth;
    private int againStringHeight;
    private int menuStringWidth;
    private int menuStringHeight;
    private boolean mouseBeenReleased = false;

    public GameOverState(int state) {
        this.stateID = state;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.menuBackground = new Image("res/graphics/game_over_background.png");
        try {
            titleFont = new AngelCodeFont("res/fonts/fsb60.fnt", "res/fonts/fsb60.png");
            smallButtonFont = new AngelCodeFont("res/fonts/fsb30.fnt", "res/fonts/fsb30.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        this.menuBackground.draw(0.0f, 0.0f);
        titleFont.drawString(18.0f, 10.0f, "Game Over", Color.lightGray);
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        this.againString = "Play Again";
        this.againStringWidth = smallButtonFont.getWidth(this.againString);
        this.againStringHeight = smallButtonFont.getHeight(this.againString);
        if (posX >= 20 && posX <= 20 + this.againStringWidth && posY >= 550 && posY <= 550 + this.againStringHeight) {
            smallButtonFont.drawString(20.0f, 550.0f, this.againString, Color.white);
        } else {
            smallButtonFont.drawString(20.0f, 550.0f, this.againString, Color.lightGray);
        }
        this.menuString = "Menu";
        this.menuStringWidth = smallButtonFont.getWidth(this.menuString);
        this.menuStringHeight = smallButtonFont.getHeight(this.menuString);
        if (posX >= 40 + this.againStringWidth && posX <= 40 + this.againStringWidth + this.menuStringWidth && posY >= 550 && posY <= 550 + this.menuStringHeight) {
            smallButtonFont.drawString(40 + this.againStringWidth, 550.0f, this.menuString, Color.white);
        } else {
            smallButtonFont.drawString(40 + this.againStringWidth, 550.0f, this.menuString, Color.lightGray);
        }
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (!this.mouseBeenReleased && !Mouse.isButtonDown(0)) {
            this.mouseBeenReleased = true;
        }
        if (posX >= 20 && posX <= 20 + this.againStringWidth && posY >= 550 && posY <= 550 + this.againStringHeight && Mouse.isButtonDown(0) && this.mouseBeenReleased) {
            this.mouseBeenReleased = false;
            sbg.enterState(1);
        }
        if (posX >= 40 + this.againStringWidth && posX <= 40 + this.againStringWidth + this.menuStringWidth && posY >= 550 && posY <= 550 + this.menuStringHeight && Mouse.isButtonDown(0) && this.mouseBeenReleased) {
            this.mouseBeenReleased = false;
            sbg.enterState(0);
        }
    }

    @Override
    public int getID() {
        return this.stateID;
    }
}

