/*
 * Decompiled with CFR 0.152.
 */
package states;

import java.awt.Desktop;
import java.net.URI;
import org.lwjgl.input.Mouse;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class MenuState
extends BasicGameState {
    private int stateID;
    private static AngelCodeFont titleFont;
    private static AngelCodeFont mainButtonFont;
    private static AngelCodeFont smallButtonFont;
    private Image menuBackground;
    private String playString;
    private String websiteString;
    private String controlsString;
    private int playStringWidth;
    private int playStringHeight;
    private int websiteStringWidth;
    private int websiteStringHeight;
    private int controlsStringWidth;
    private int controlsStringHeight;
    private boolean mouseBeenReleased = false;

    public MenuState(int state) {
        this.stateID = state;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.menuBackground = new Image("res/graphics/menu_background.png");
        try {
            titleFont = new AngelCodeFont("res/fonts/fsb72.fnt", "res/fonts/fsb72.png");
            mainButtonFont = new AngelCodeFont("res/fonts/fsb50.fnt", "res/fonts/fsb50.png");
            smallButtonFont = new AngelCodeFont("res/fonts/fsb30.fnt", "res/fonts/fsb30.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        this.menuBackground.draw(0.0f, 0.0f);
        titleFont.drawString(15.0f, 10.0f, sbg.getTitle(), Color.lightGray);
        smallButtonFont.drawString(20.0f, 90.0f, "by Team BHD", Color.lightGray);
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        this.playString = "Play";
        this.playStringWidth = mainButtonFont.getWidth(this.playString);
        this.playStringHeight = mainButtonFont.getHeight(this.playString);
        if (posX >= 20 && posX <= 20 + this.playStringWidth && posY >= 480 && posY <= 480 + this.playStringHeight) {
            mainButtonFont.drawString(19.0f, 480.0f, this.playString, Color.white);
        } else {
            mainButtonFont.drawString(19.0f, 480.0f, this.playString, Color.lightGray);
        }
        this.controlsString = "Help";
        this.controlsStringWidth = smallButtonFont.getWidth(this.controlsString);
        this.controlsStringHeight = smallButtonFont.getHeight(this.controlsString);
        if (posX >= 20 && posX <= 20 + this.controlsStringWidth && posY >= 550 && posY <= 550 + this.controlsStringHeight) {
            smallButtonFont.drawString(20.0f, 550.0f, this.controlsString, Color.white);
        } else {
            smallButtonFont.drawString(20.0f, 550.0f, this.controlsString, Color.lightGray);
        }
        this.websiteString = "Team Website";
        this.websiteStringWidth = smallButtonFont.getWidth(this.websiteString);
        this.websiteStringHeight = smallButtonFont.getHeight(this.websiteString);
        if (posX >= 40 + this.controlsStringWidth && posX <= 40 + this.controlsStringWidth + this.websiteStringWidth && posY >= 550 && posY <= 550 + this.websiteStringHeight) {
            smallButtonFont.drawString(40 + this.controlsStringWidth, 550.0f, this.websiteString, Color.white);
        } else {
            smallButtonFont.drawString(40 + this.controlsStringWidth, 550.0f, this.websiteString, Color.lightGray);
        }
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (!this.mouseBeenReleased && !Mouse.isButtonDown(0)) {
            this.mouseBeenReleased = true;
        }
        if (this.mouseBeenReleased) {
            if (posX >= 20 && posX <= 20 + this.playStringWidth && posY >= 480 && posY <= 480 + this.playStringHeight && Mouse.isButtonDown(0)) {
                this.mouseBeenReleased = false;
                sbg.enterState(1);
            }
            if (posX >= 20 && posX <= 20 + this.controlsStringWidth && posY >= 550 && posY <= 550 + this.controlsStringHeight && Mouse.isButtonDown(0)) {
                this.mouseBeenReleased = false;
                sbg.enterState(4);
            }
            if (posX >= 40 + this.controlsStringWidth && posX <= 40 + this.controlsStringWidth + this.websiteStringWidth && posY >= 550 && posY <= 550 + this.websiteStringHeight && Mouse.isButtonDown(0)) {
                this.mouseBeenReleased = false;
                try {
                    Desktop.getDesktop().browse(new URI("http://teambhd.github.io"));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    @Override
    public int getID() {
        return this.stateID;
    }
}

