/*
 * Decompiled with CFR 0.152.
 */
package states;

import org.lwjgl.input.Mouse;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;

public class PauseState
extends BasicGameState {
    private int stateID;
    private static AngelCodeFont titleFont;
    private static AngelCodeFont smallButtonFont;
    private Image menuBackground;
    private String backString;
    private int backStringHeight;
    private int backStringWidth;

    public PauseState(int state) {
        this.stateID = state;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.menuBackground = new Image("res/graphics/menu_background.png");
        try {
            titleFont = new AngelCodeFont("res/fonts/fsb60.fnt", "res/fonts/fsb60.png");
            smallButtonFont = new AngelCodeFont("res/fonts/fsb30.fnt", "res/fonts/fsb30.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        this.menuBackground.draw(0.0f, 0.0f);
        titleFont.drawString(18.0f, 10.0f, "Paused", Color.lightGray);
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        this.backString = "Resume";
        this.backStringWidth = smallButtonFont.getWidth(this.backString);
        this.backStringHeight = smallButtonFont.getHeight(this.backString);
        if (posX >= 20 && posX <= 20 + this.backStringWidth && posY >= 550 && posY <= 550 + this.backStringHeight) {
            smallButtonFont.drawString(20.0f, 550.0f, this.backString, Color.white);
        } else {
            smallButtonFont.drawString(20.0f, 550.0f, this.backString, Color.lightGray);
        }
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        Input input = gc.getInput();
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (posX >= 20 && posX <= 20 + this.backStringWidth && posY >= 550 && posY <= 550 + this.backStringHeight && Mouse.isButtonDown(0)) {
            sbg.enterState(1);
        }
        if (input.isKeyPressed(25) || input.isKeyPressed(57)) {
            sbg.enterState(1);
        }
    }

    @Override
    public int getID() {
        return this.stateID;
    }
}

