/*
 * Decompiled with CFR 0.152.
 */
package states;

import java.awt.Font;
import java.io.InputStream;
import logicClasses.Airspace;
import org.lwjgl.input.Mouse;
import org.newdawn.slick.AngelCodeFont;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.Sound;
import org.newdawn.slick.TrueTypeFont;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import org.newdawn.slick.util.ResourceLoader;

public class PlayState
extends BasicGameState {
    private int stateID;
    private Airspace airspace;
    Image cursorImg;
    public static float time;
    private Sound endOfGameSound;
    public static TrueTypeFont font;
    private static AngelCodeFont smallButtonFont;
    private static AngelCodeFont titleFont;
    private Image controlBarImage;
    private Image clockImage;
    private Image scoreImage;
    private Image backgroundImage;
    private Image difficultyBackground;
    private String stringTime;
    private String stringScore;
    private boolean settingDifficulty;
    private boolean gameEnded;
    private String easyString;
    private String mediumString;
    private String hardString;
    private int easyStringHeight;
    private int easyStringWidth;
    private int mediumStringHeight;
    private int mediumStringWidth;
    private int hardStringHeight;
    private int hardStringWidth;

    public PlayState(int state) {
        this.stateID = state;
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.gameEnded = false;
        this.settingDifficulty = true;
        time = 0.0f;
        this.airspace = new Airspace();
        this.stringTime = "";
        this.stringScore = "";
        try {
            InputStream inputStream1 = ResourceLoader.getResourceAsStream("res/fonts/fira-sans.ttf");
            Font awtFont1 = Font.createFont(0, inputStream1);
            awtFont1 = awtFont1.deriveFont(16.0f);
            font = new TrueTypeFont(awtFont1, true);
            titleFont = new AngelCodeFont("res/fonts/fsb60.fnt", "res/fonts/fsb60.png");
            smallButtonFont = new AngelCodeFont("res/fonts/fsb30.fnt", "res/fonts/fsb30.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.endOfGameSound = new Sound("res/music/175385__digitaldominic__scream.wav");
        this.controlBarImage = new Image("res/graphics/control_bar_vertical.png");
        this.clockImage = new Image("res/icons/clock.png");
        this.scoreImage = new Image("res/icons/asterisk_orange.png");
        this.backgroundImage = new Image("res/graphics/background.png");
        this.difficultyBackground = new Image("res/graphics/menu_background.png");
        this.airspace.newWaypoint(350, 150, "A");
        this.airspace.newWaypoint(400, 470, "B");
        this.airspace.newWaypoint(700, 60, "C");
        this.airspace.newWaypoint(800, 320, "D");
        this.airspace.newWaypoint(600, 418, "E");
        this.airspace.newWaypoint(500, 260, "F");
        this.airspace.newWaypoint(950, 188, "G");
        this.airspace.newWaypoint(1050, 272, "H");
        this.airspace.newWaypoint(900, 420, "I");
        this.airspace.newWaypoint(240, 250, "J");
        this.airspace.newEntryPoint(150, 400);
        this.airspace.newEntryPoint(1200, 200);
        this.airspace.newEntryPoint(600, 0);
        this.airspace.newExitPoint(800, 0, "1");
        this.airspace.newExitPoint(150, 200, "2");
        this.airspace.newExitPoint(1200, 300, "3");
        this.airspace.init(gc);
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        if (this.settingDifficulty) {
            this.difficultyBackground.draw(0.0f, 0.0f);
            titleFont.drawString(18.0f, 10.0f, "Set the difficulty", Color.lightGray);
            int posX = Mouse.getX();
            int posY = 600 - Mouse.getY();
            this.easyString = "Easy";
            this.easyStringWidth = smallButtonFont.getWidth(this.easyString);
            this.easyStringHeight = smallButtonFont.getHeight(this.easyString);
            if (posX >= 20 && posX <= 20 + this.easyStringWidth && posY >= 550 && posY <= 550 + this.easyStringHeight) {
                smallButtonFont.drawString(20.0f, 550.0f, this.easyString, Color.white);
            } else {
                smallButtonFont.drawString(20.0f, 550.0f, this.easyString, Color.lightGray);
            }
            this.mediumString = "Medium";
            this.mediumStringWidth = smallButtonFont.getWidth(this.mediumString);
            this.mediumStringHeight = smallButtonFont.getHeight(this.mediumString);
            if (posX >= 40 + this.easyStringWidth && posX <= 40 + this.easyStringWidth + this.mediumStringWidth && posY >= 550 && posY <= 550 + this.mediumStringHeight) {
                smallButtonFont.drawString(40 + this.easyStringWidth, 550.0f, this.mediumString, Color.white);
            } else {
                smallButtonFont.drawString(40 + this.easyStringWidth, 550.0f, this.mediumString, Color.lightGray);
            }
            this.hardString = "Hard";
            this.hardStringWidth = smallButtonFont.getWidth(this.hardString);
            this.hardStringHeight = smallButtonFont.getHeight(this.hardString);
            if (posX >= 60 + this.easyStringWidth + this.mediumStringWidth && posX <= 60 + this.easyStringWidth + this.mediumStringWidth + this.hardStringWidth && posY >= 550 && posY <= 550 + this.hardStringHeight) {
                smallButtonFont.drawString(60 + this.easyStringWidth + this.mediumStringWidth, 550.0f, this.hardString, Color.white);
            } else {
                smallButtonFont.drawString(60 + this.easyStringWidth + this.mediumStringWidth, 550.0f, this.hardString, Color.lightGray);
            }
        } else {
            g.setFont(font);
            this.backgroundImage.draw(150.0f, 0.0f);
            this.controlBarImage.draw(0.0f, 0.0f);
            this.airspace.render(g, gc);
            g.setColor(Color.white);
            this.clockImage.draw(5.0f, 12.0f);
            g.drawString(this.stringTime, 25.0f, 11.0f);
            this.scoreImage.draw(75.0f, 12.0f);
            g.drawString(this.stringScore, 95.0f, 11.0f);
        }
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        if (this.gameEnded) {
            this.airspace.resetAirspace();
            time = 0.0f;
            this.gameEnded = false;
            this.settingDifficulty = true;
        }
        if (this.settingDifficulty) {
            int posX = Mouse.getX();
            int posY = 600 - Mouse.getY();
            if (posX >= 20 && posX <= 20 + this.easyStringWidth && posY >= 550 && posY <= 550 + this.easyStringHeight && Mouse.isButtonDown(0)) {
                this.airspace.setDifficultyValueOfGame(1);
                this.airspace.getControls().setDifficultyValueOfGame(1);
                this.airspace.createAndSetSeparationRules();
                this.settingDifficulty = false;
            }
            if (posX >= 40 + this.easyStringWidth && posX <= 40 + this.easyStringWidth + this.mediumStringWidth && posY >= 550 && posY <= 550 + this.mediumStringHeight && Mouse.isButtonDown(0)) {
                this.airspace.setDifficultyValueOfGame(2);
                this.airspace.getControls().setDifficultyValueOfGame(2);
                this.airspace.createAndSetSeparationRules();
                this.settingDifficulty = false;
            }
            if (posX >= 60 + this.easyStringWidth + this.mediumStringWidth && posX <= 60 + this.easyStringWidth + this.mediumStringWidth + this.hardStringWidth && posY >= 550 && posY <= 550 + this.hardStringHeight && Mouse.isButtonDown(0)) {
                this.airspace.setDifficultyValueOfGame(3);
                this.airspace.getControls().setDifficultyValueOfGame(3);
                this.airspace.createAndSetSeparationRules();
                this.settingDifficulty = false;
            }
        } else {
            Input input;
            float decMins = (time += (float)delta) / 1000.0f / 60.0f;
            int mins = (int)decMins;
            float decSecs = decMins - (float)mins;
            int secs = Math.round(decSecs * 60.0f);
            if (secs == 60) {
                secs = 0;
                ++mins;
            }
            String stringMins = "0" + mins;
            stringMins = stringMins.substring(stringMins.length() - 2);
            String stringSecs = "0" + secs;
            stringSecs = stringSecs.substring(stringSecs.length() - 2);
            this.stringTime = stringMins + ":" + stringSecs;
            this.stringScore = Integer.toString(this.airspace.getScore());
            this.airspace.newFlight(gc);
            this.airspace.update(gc);
            if (this.airspace.getSeparationRules().getGameOverViolation()) {
                this.airspace.getSeparationRules().setGameOverViolation(false);
                this.airspace.resetAirspace();
                this.endOfGameSound.play();
                sbg.enterState(2);
                this.gameEnded = true;
            }
            if ((input = gc.getInput()).isKeyPressed(25) || input.isKeyPressed(57)) {
                sbg.enterState(3);
            }
        }
    }

    public Airspace getAirspace() {
        return this.airspace;
    }

    public void setAirspace(Airspace airspace) {
        this.airspace = airspace;
    }

    @Override
    public int getID() {
        return this.stateID;
    }
}

