/*
 * Decompiled with CFR 0.152.
 */
package unitTests;

import logicClasses.Airspace;
import logicClasses.Flight;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Airspace_Tests {
    private Airspace airspace;
    private Flight flight1;

    @Before
    public void setUp() {
        this.airspace = new Airspace();
        this.airspace.newWaypoint(350, 150, "A");
        this.airspace.newWaypoint(400, 470, "B");
        this.airspace.newWaypoint(700, 60, "C");
        this.airspace.newWaypoint(800, 320, "D");
        this.airspace.newWaypoint(600, 418, "E");
        this.airspace.newWaypoint(500, 220, "F");
        this.airspace.newWaypoint(950, 188, "G");
        this.airspace.newWaypoint(1050, 272, "H");
        this.airspace.newWaypoint(900, 420, "I");
        this.airspace.newWaypoint(240, 250, "J");
        this.airspace.newEntryPoint(150, 400);
        this.airspace.newEntryPoint(1200, 200);
        this.airspace.newEntryPoint(600, 0);
        this.airspace.newExitPoint(800, 0, "1");
        this.airspace.newExitPoint(150, 200, "2");
        this.airspace.newExitPoint(1200, 300, "3");
        this.airspace.newAirport(572, 197);
        this.flight1 = new Flight(this.airspace, 0);
        this.airspace.setDifficultyValueOfGame(1);
        this.airspace.createAndSetSeparationRules();
    }

    @Test
    public void resetAirspaceTest() {
        this.airspace.resetAirspace();
        Assert.assertTrue(this.airspace.getListOfFlights().size() == 0);
        Assert.assertTrue(this.airspace.getNumberOfGameLoops() == 0);
        Assert.assertTrue(this.airspace.getNumberOfGameLoopsWhenDifficultyIncreases() == 3600);
        Assert.assertTrue(!this.airspace.getSeparationRules().getGameOverViolation());
        Assert.assertTrue(this.airspace.getControls().getSelectedFlight() == null);
    }

    @Test
    public void newWaypointTest() {
        Assert.assertTrue(this.airspace.newWaypoint(151, 500, "TEST"));
        Assert.assertFalse(this.airspace.newWaypoint(-10000, 151, "TEST2"));
        Assert.assertFalse(this.airspace.newWaypoint(50, 0, "TEST3"));
    }

    public void newAirportTest() {
        Assert.assertTrue(this.airspace.newAirport(151, 500));
        Assert.assertFalse(this.airspace.newAirport(-10000, 151));
        Assert.assertFalse(this.airspace.newAirport(50, 0));
    }

    @Test
    public void newExitPointTest() {
        Assert.assertTrue(this.airspace.newExitPoint(150, 500, "TEST"));
        Assert.assertFalse(this.airspace.newExitPoint(-100, 220, "TEST2"));
        Assert.assertFalse(this.airspace.newExitPoint(0, 23, "TEST3"));
    }

    @Test
    public void newEntryPointTest() {
        Assert.assertTrue(this.airspace.newEntryPoint(150, 500));
        Assert.assertFalse(this.airspace.newEntryPoint(60, -540));
        Assert.assertFalse(this.airspace.newEntryPoint(0, 0));
    }

    @Test
    public void generateFlightNameTest() {
        String name = this.airspace.generateFlightName();
        Assert.assertTrue(name.length() == 6);
    }

    @Test
    public void checkIfFlightHasLeftAirspaceTest() {
        this.flight1.setX(100.0);
        this.flight1.setY(-50.0);
        Assert.assertFalse(this.airspace.checkIfFlightHasLeftAirspace(this.flight1));
        this.flight1.setX(1250.0);
        this.flight1.setY(650.0);
        Assert.assertFalse(this.airspace.checkIfFlightHasLeftAirspace(this.flight1));
        this.flight1.setX(1251.0);
        this.flight1.setY(5.0);
        Assert.assertTrue(this.airspace.checkIfFlightHasLeftAirspace(this.flight1));
        this.flight1.setX(101.0);
        this.flight1.setY(0.0);
        Assert.assertFalse(this.airspace.checkIfFlightHasLeftAirspace(this.flight1));
        this.flight1.setX(-143401.0);
        this.flight1.setY(101010.0);
        Assert.assertTrue(this.airspace.checkIfFlightHasLeftAirspace(this.flight1));
    }

    @Test
    public void changeScoreTest() {
        int score = 10;
        this.airspace.changeScore(score);
        int oldscore = this.airspace.getScore();
        Assert.assertTrue(this.airspace.getScore() == score);
        this.airspace.changeScore(score += 10);
        Assert.assertTrue(this.airspace.getScore() == oldscore + score);
    }

    @Test
    public void RemoveSpecificTest1() {
        this.airspace.addFlight(this.flight1);
        this.airspace.removeSpecificFlight(0);
        Assert.assertTrue(this.airspace.getScore() == -200);
    }

    @Test
    public void RemoveSpecificTest2() {
        this.airspace.addFlight(this.flight1);
        while (this.flight1.getFlightPlan().getCurrentRoute().size() != 0) {
            this.flight1.getFlightPlan().getCurrentRoute().remove(0);
        }
        this.airspace.removeSpecificFlight(0);
        Assert.assertTrue(this.airspace.getScore() == 200);
    }
}

