/*
 * Decompiled with CFR 0.152.
 */
package unitTests;

import java.util.ArrayList;
import logicClasses.Airspace;
import logicClasses.EntryPoint;
import logicClasses.Flight;
import logicClasses.FlightPlan;
import logicClasses.Point;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FlightPlan_Tests {
    private Airspace airspace;
    private Flight flight1;
    private FlightPlan flightplan;

    @Before
    public void setUp() {
        this.airspace = new Airspace();
        this.airspace.newWaypoint(350, 150, "A");
        this.airspace.newWaypoint(400, 470, "B");
        this.airspace.newWaypoint(700, 60, "C");
        this.airspace.newWaypoint(800, 320, "D");
        this.airspace.newWaypoint(600, 418, "E");
        this.airspace.newWaypoint(500, 220, "F");
        this.airspace.newWaypoint(950, 188, "G");
        this.airspace.newWaypoint(1050, 272, "H");
        this.airspace.newWaypoint(900, 420, "I");
        this.airspace.newWaypoint(240, 250, "J");
        this.airspace.newEntryPoint(150, 400);
        this.airspace.newEntryPoint(1200, 200);
        this.airspace.newEntryPoint(600, 0);
        this.airspace.newExitPoint(800, 0, "1");
        this.airspace.newExitPoint(150, 200, "2");
        this.airspace.newExitPoint(1200, 300, "3");
        this.flight1 = new Flight(this.airspace, 2);
        this.flightplan = new FlightPlan(this.airspace, this.flight1, 4);
    }

    @Test
    public void generateEntryPointTest1() {
        EntryPoint result = this.flight1.getFlightPlan().generateEntryPoint(this.airspace, 2);
        Assert.assertTrue(result == this.airspace.getListOfEntryPoints().get(0) || result == this.airspace.getListOfEntryPoints().get(1) || result == this.airspace.getListOfEntryPoints().get(2));
    }

    @Test
    public void generateEntryPointTest2() {
        EntryPoint result = this.flight1.getFlightPlan().generateEntryPoint(this.airspace, 4);
        Assert.assertTrue(result == this.airspace.getListOfEntryPoints().get(0) || result == this.airspace.getListOfEntryPoints().get(1) || result == this.airspace.getListOfEntryPoints().get(2));
        Assert.assertEquals(this.flight1.getX(), this.airspace.getAirport().getX(), 0.1);
        Assert.assertEquals(this.flight1.getY(), this.airspace.getAirport().getY(), 0.1);
    }

    @Test
    public void generateVelocityTest() {
        for (int i = 0; i < 100; ++i) {
            double velocity = this.flightplan.generateVelocity();
            Assert.assertTrue(velocity < 400.0 && velocity >= 100.0);
        }
    }

    @Test
    public void buildRouteTest1() {
        for (int i = 0; i < 100; ++i) {
            ArrayList<Point> route = this.flightplan.buildRoute(this.airspace, this.flight1.getFlightPlan().getEntryPoint(), 4);
            Assert.assertTrue(route.size() >= 2 && route.size() <= 5);
        }
    }

    @Test
    public void buildRouteTest2() {
        for (int i = 0; i < 100; ++i) {
            ArrayList<Point> route = this.flightplan.buildRoute(this.airspace, this.flight1.getFlightPlan().getEntryPoint(), 3);
            boolean samePoint = false;
            for (int j = 0; j < route.size(); ++j) {
                for (int k = j + 1; k < route.size(); ++k) {
                    if (!route.get(j).equals(route.get(k))) continue;
                    samePoint = true;
                }
            }
            Assert.assertFalse(samePoint);
        }
    }

    @Test
    public void buildRouteTest3() {
        Airspace airspaceMissingExitPoints = new Airspace();
        airspaceMissingExitPoints.newEntryPoint(150, 400);
        airspaceMissingExitPoints.newEntryPoint(1200, 200);
        airspaceMissingExitPoints.newEntryPoint(600, 0);
        airspaceMissingExitPoints.newWaypoint(350, 150, "A");
        airspaceMissingExitPoints.newWaypoint(400, 470, "B");
        airspaceMissingExitPoints.newWaypoint(700, 60, "C");
        airspaceMissingExitPoints.newWaypoint(800, 320, "D");
        airspaceMissingExitPoints.newWaypoint(600, 418, "E");
        airspaceMissingExitPoints.newWaypoint(500, 220, "F");
        airspaceMissingExitPoints.newWaypoint(950, 188, "G");
        airspaceMissingExitPoints.newWaypoint(1050, 272, "H");
        airspaceMissingExitPoints.newWaypoint(900, 420, "I");
        airspaceMissingExitPoints.newWaypoint(240, 250, "J");
        Flight flight1 = new Flight(airspaceMissingExitPoints, 2);
        ArrayList<Point> route = this.flightplan.buildRoute(airspaceMissingExitPoints, flight1.getFlightPlan().getEntryPoint(), 2);
        Assert.assertTrue(route.size() == 0);
    }

    @Test
    public void buildRouteTest4() {
        Airspace airspaceMissingWaypoints = new Airspace();
        airspaceMissingWaypoints.newEntryPoint(150, 400);
        airspaceMissingWaypoints.newEntryPoint(1200, 200);
        airspaceMissingWaypoints.newEntryPoint(600, 0);
        airspaceMissingWaypoints.newExitPoint(800, 0, "1");
        airspaceMissingWaypoints.newExitPoint(150, 200, "2");
        airspaceMissingWaypoints.newExitPoint(1200, 300, "3");
        Flight flight1 = new Flight(airspaceMissingWaypoints, 4);
        ArrayList<Point> route = this.flightplan.buildRoute(airspaceMissingWaypoints, flight1.getFlightPlan().getEntryPoint(), 0);
        Assert.assertTrue(route.size() == 0);
    }

    @Test
    public void updateFlightPlanTest() {
        int previousSize = this.flight1.getFlightPlan().getCurrentRoute().size();
        this.flight1.setX(this.flight1.getFlightPlan().getCurrentRoute().get(0).getX());
        this.flight1.setY(this.flight1.getFlightPlan().getCurrentRoute().get(0).getY());
        this.flight1.getFlightPlan().updateFlightPlan();
        Assert.assertEquals(previousSize - 1, (float)this.flight1.getFlightPlan().getCurrentRoute().size(), 0.0f);
        Assert.assertEquals(100.0, (double)this.airspace.getScore(), 0.1);
    }

    @Test
    public void updateFlightPlanTest2() {
        int previousSize = this.flight1.getFlightPlan().getCurrentRoute().size();
        this.flight1.setX(this.flight1.getFlightPlan().getCurrentRoute().get(0).getX() + 100.0);
        this.flight1.setY(this.flight1.getFlightPlan().getCurrentRoute().get(0).getY() + 100.0);
        this.flight1.getFlightPlan().updateFlightPlan();
        Assert.assertEquals(previousSize, (float)this.flight1.getFlightPlan().getCurrentRoute().size(), 0.0f);
    }
}

