/*
 * Decompiled with CFR 0.152.
 */
package unitTests;

import logicClasses.Airspace;
import logicClasses.Flight;
import logicClasses.Waypoint;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class Flight_Tests {
    private Airspace airspace;
    private Flight flight1;
    private Flight flight2;

    @Before
    public void setUp() {
        this.airspace = new Airspace();
        this.airspace.newWaypoint(350, 150, "A");
        this.airspace.newWaypoint(400, 470, "B");
        this.airspace.newWaypoint(700, 60, "C");
        this.airspace.newWaypoint(800, 320, "D");
        this.airspace.newWaypoint(600, 418, "E");
        this.airspace.newWaypoint(500, 220, "F");
        this.airspace.newWaypoint(950, 188, "G");
        this.airspace.newWaypoint(1050, 272, "H");
        this.airspace.newWaypoint(900, 420, "I");
        this.airspace.newWaypoint(240, 250, "J");
        this.airspace.newEntryPoint(150, 400);
        this.airspace.newEntryPoint(1200, 200);
        this.airspace.newEntryPoint(600, 0);
        this.airspace.newExitPoint(800, 0, "1");
        this.airspace.newExitPoint(150, 200, "2");
        this.airspace.newExitPoint(1200, 300, "3");
        this.flight1 = new Flight(this.airspace, 0);
        this.flight2 = new Flight(this.airspace, 4);
    }

    @Test
    public void generateAltitudeTest1() {
        int result = this.flight1.generateAltitude(3);
        Assert.assertTrue(result >= 1000 && result <= 10000);
    }

    @Test
    public void calculateHeadingToFirstWaypointTest1() {
        this.flight1.setX(150.0);
        this.flight1.setY(400.0);
        Assert.assertEquals(38.65, this.flight1.calculateHeadingToFirstWaypoint(350.0, 150.0), 0.01);
    }

    @Test
    public void calculateHeadingToFirstWaypointTest2() {
        this.flight1.setX(350.0);
        this.flight1.setY(400.0);
        Assert.assertEquals(321.34, this.flight1.calculateHeadingToFirstWaypoint(150.0, 150.0), 0.01);
    }

    @Test
    public void turnFlightLeftTest1() {
        this.flight1.setTargetHeading(10.0);
        this.flight1.setCurrentHeading(10.0);
        this.flight1.turnFlightLeft(20);
        Assert.assertEquals(350.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void turnFlightLeftTest2() {
        this.flight1.setTargetHeading(270.0);
        this.flight1.setCurrentHeading(270.0);
        this.flight1.turnFlightLeft(90);
        Assert.assertEquals(180.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void turnFlightLeftTest3() {
        this.flight1.setTargetHeading(90.0);
        this.flight1.setCurrentHeading(90.0);
        this.flight1.turnFlightLeft(90);
        Assert.assertEquals(0.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void turnFlightRightTest1() {
        this.flight1.setTargetHeading(0.0);
        this.flight1.setCurrentHeading(0.0);
        this.flight1.turnFlightRight(30);
        Assert.assertEquals(30.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void turnFlightRightTest2() {
        this.flight1.setTargetHeading(270.0);
        this.flight1.setCurrentHeading(270.0);
        this.flight1.turnFlightRight(100);
        Assert.assertEquals(10.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void turnFlightRightTest3() {
        this.flight1.setTargetHeading(270.0);
        this.flight1.setCurrentHeading(270.0);
        this.flight1.turnFlightRight(90);
        Assert.assertEquals(0.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void giveHeadingTest1() {
        this.flight1.setTargetHeading(0.0);
        this.flight1.setCurrentHeading(0.0);
        this.flight1.giveHeading(0);
        Assert.assertEquals(0.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void giveHeadingTest2() {
        this.flight1.setTargetHeading(0.0);
        this.flight1.setCurrentHeading(0.0);
        this.flight1.giveHeading(360);
        Assert.assertEquals(0.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void giveHeadingTest3() {
        this.flight1.setTargetHeading(0.0);
        this.flight1.setCurrentHeading(0.0);
        this.flight1.giveHeading(90);
        Assert.assertEquals(90.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void giveHeadingTest4() {
        this.flight1.setTargetHeading(0.0);
        this.flight1.setCurrentHeading(0.0);
        this.flight1.giveHeading(3610);
        Assert.assertEquals(10.0, this.flight1.getTargetHeading(), 0.1);
    }

    @Test
    public void checkIfFlightAtWaypointTest1() {
        Waypoint waypoint = new Waypoint(350.0, 150.0, "TEST");
        this.flight1.setX(335.0);
        this.flight1.setY(135.0);
        Assert.assertTrue(this.flight1.checkIfFlightAtWaypoint(waypoint));
    }

    @Test
    public void checkIfFlightAtWaypointTest2() {
        Waypoint waypoint = new Waypoint(350.0, 150.0, "TEST");
        this.flight1.setX(350.0);
        this.flight1.setY(150.0);
        Assert.assertTrue(this.flight1.checkIfFlightAtWaypoint(waypoint));
    }

    @Test
    public void checkIfFlightAtWaypointTest3() {
        Waypoint waypoint = new Waypoint(350.0, 150.0, "TEST");
        this.flight1.setX(1000.0);
        this.flight1.setY(1000.0);
        Assert.assertFalse(this.flight1.checkIfFlightAtWaypoint(waypoint));
    }

    @Test
    public void checkIfFlightAtWaypointTest4() {
        Waypoint waypoint = new Waypoint(350.0, 150.0, "TEST");
        this.flight1.setX(1000.0);
        this.flight1.setY(150.0);
        Assert.assertFalse(this.flight1.checkIfFlightAtWaypoint(waypoint));
    }

    @Test
    public void checkIfFlightAtWaypointTest5() {
        Waypoint waypoint = new Waypoint(350.0, 150.0, "TEST");
        this.flight1.setX(350.0);
        this.flight1.setY(1000.0);
        Assert.assertFalse(this.flight1.checkIfFlightAtWaypoint(waypoint));
    }

    @Test
    public void updateXYCoordinates() {
        this.flight1.getFlightPlan().setVelocity(300.0);
        this.flight1.setCurrentHeading(50.0);
        this.flight1.setTargetHeading(50.0);
        this.flight1.setX(100.0);
        this.flight1.setY(100.0);
        this.flight1.updateXYCoordinates();
        Assert.assertEquals(100.2, this.flight1.getX(), 0.1);
        Assert.assertEquals(99.8, this.flight1.getY(), 0.1);
    }

    @Test
    public void updateAltitudeTest1() {
        this.flight1.setAltitude(5996);
        this.flight1.setTargetAltitude(6000);
        this.flight1.updateAltitude();
        Assert.assertEquals(6000.0, (double)this.flight1.getAltitude(), 0.1);
    }

    @Test
    public void updateAltitudeTest2() {
        this.flight1.setCurrentAltitude(4000);
        this.flight1.setTargetAltitude(4000);
        this.flight1.updateAltitude();
        Assert.assertEquals(4000.0, (double)this.flight1.getAltitude(), 0.1);
    }

    @Test
    public void updateAltitudeTest3() {
        this.flight1.setCurrentAltitude(2996);
        this.flight1.setTargetAltitude(3000);
        this.flight1.updateAltitude();
        Assert.assertEquals(3000.0, (double)this.flight1.getAltitude(), 0.1);
    }

    @Test
    public void updateAltitudeTest4() {
        this.flight1.setCurrentAltitude(5004);
        this.flight1.setTargetAltitude(5000);
        this.flight1.updateAltitude();
        Assert.assertEquals(5000.0, (double)this.flight1.getAltitude(), 0.1);
    }

    @Test
    public void updateAltitudeTest5() {
        this.flight1.setCurrentAltitude(8004);
        this.flight1.setTargetAltitude(8000);
        this.flight1.updateAltitude();
        Assert.assertEquals(8000.0, (double)this.flight1.getAltitude(), 0.1);
    }

    @Test
    public void updateVelocityTest1() {
        this.flight1.getFlightPlan().setVelocity(200.0);
        this.flight1.getFlightPlan().setTargetVelocity(225.0);
        this.flight1.updateVelocity();
        Assert.assertEquals(200.25, this.flight1.getFlightPlan().getVelocity(), 0.1);
    }

    @Test
    public void updateVelocityTest2() {
        this.flight1.getFlightPlan().setVelocity(100.0);
        this.flight1.getFlightPlan().setTargetVelocity(225.0);
        this.flight1.updateVelocity();
        Assert.assertEquals(100.25, this.flight1.getFlightPlan().getVelocity(), 0.1);
    }

    @Test
    public void updateVelocityTest3() {
        this.flight1.getFlightPlan().setVelocity(400.0);
        this.flight1.getFlightPlan().setTargetVelocity(225.0);
        this.flight1.updateVelocity();
        Assert.assertEquals(399.75, this.flight1.getFlightPlan().getVelocity(), 0.1);
    }

    @Test
    public void updateVelocityTest4() {
        this.flight1.getFlightPlan().setVelocity(200.0);
        this.flight1.getFlightPlan().setTargetVelocity(100.0);
        this.flight1.updateVelocity();
        Assert.assertEquals(199.75, this.flight1.getFlightPlan().getVelocity(), 0.1);
    }

    @Test
    public void updateVelocityTest5() {
        this.flight1.getFlightPlan().setVelocity(225.0);
        this.flight1.getFlightPlan().setTargetVelocity(225.0);
        this.flight1.updateVelocity();
        Assert.assertEquals(225.0, this.flight1.getFlightPlan().getVelocity(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest1() {
        this.flight1.setCurrentHeading(288.0);
        this.flight1.setTargetHeading(0.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningRight());
        Assert.assertFalse(this.flight1.getTurningLeft());
        Assert.assertEquals(288.5, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest2() {
        this.flight1.setCurrentHeading(288.0);
        this.flight1.setTargetHeading(270.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningLeft());
        Assert.assertFalse(this.flight1.getTurningRight());
        Assert.assertEquals(287.5, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest3() {
        this.flight1.setCurrentHeading(270.0);
        this.flight1.setTargetHeading(90.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningRight());
        Assert.assertFalse(this.flight1.getTurningLeft());
        Assert.assertEquals(270.5, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest4() {
        this.flight1.setCurrentHeading(288.0);
        this.flight1.setTargetHeading(300.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningRight());
        Assert.assertFalse(this.flight1.getTurningLeft());
        Assert.assertEquals(288.5, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest5() {
        this.flight1.setCurrentHeading(150.0);
        this.flight1.setTargetHeading(200.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningRight());
        Assert.assertFalse(this.flight1.getTurningLeft());
        Assert.assertEquals(150.5, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest6() {
        this.flight1.setCurrentHeading(20.0);
        this.flight1.setTargetHeading(290.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningLeft());
        Assert.assertFalse(this.flight1.getTurningRight());
        Assert.assertEquals(19.5, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest7() {
        this.flight1.setCurrentHeading(359.5);
        this.flight1.setTargetHeading(10.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningRight());
        Assert.assertFalse(this.flight1.getTurningLeft());
        Assert.assertEquals(0.0, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void updateCurrentHeadingTest8() {
        this.flight1.setCurrentHeading(0.5);
        this.flight1.setTargetHeading(290.0);
        this.flight1.updateCurrentHeading();
        Assert.assertTrue(this.flight1.getTurningLeft());
        Assert.assertFalse(this.flight1.getTurningRight());
        Assert.assertEquals(360.0, this.flight1.getCurrentHeading(), 0.1);
    }

    @Test
    public void TakeoffTest1() {
        this.flight2.TakeOff();
        this.flight2.update();
        Assert.assertEquals(100.0, this.flight2.getFlightPlan().getTargetVelocity(), 0.1);
        Assert.assertEquals(1000.0, (double)this.flight2.getTargetAltitude(), 0.1);
    }

    @Test
    public void TakeOffTest2() {
        this.flight1.TakeOff();
        this.flight1.update();
        Assert.assertEquals(this.flight2.getFlightPlan().getVelocity(), this.flight2.getFlightPlan().getTargetVelocity(), 0.1);
        Assert.assertEquals((double)this.flight2.getAltitude(), (double)this.flight2.getTargetAltitude(), 0.1);
    }

    @Test
    public void LandTest1() {
        this.flight1.LandFlight();
        this.flight1.update();
        Assert.assertFalse(this.flight1.getLanding());
    }

    @Test
    public void LandTest2() {
        this.flight1.setX(572.0);
        this.flight1.setY(197.0);
        this.flight1.setAltitude(0);
        this.flight1.getFlightPlan().setVelocity(0.0);
        this.flight1.LandFlight();
        this.flight1.update();
        Assert.assertTrue(this.flight1.getLanding());
    }
}

