/*
 * Decompiled with CFR 0.152.
 */
package unitTests;

import logicClasses.Airspace;
import logicClasses.Flight;
import logicClasses.SeparationRules;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SeparationRules_Tests {
    private Airspace airspace;
    private SeparationRules separationRules;
    private Flight flight1;
    private Flight flight2;

    @Before
    public void setUp() {
        this.separationRules = new SeparationRules(1);
        this.airspace = new Airspace();
        this.airspace.newWaypoint(350, 150, "A");
        this.airspace.newWaypoint(400, 470, "B");
        this.airspace.newWaypoint(700, 60, "C");
        this.airspace.newWaypoint(800, 320, "D");
        this.airspace.newWaypoint(600, 418, "E");
        this.airspace.newWaypoint(500, 220, "F");
        this.airspace.newWaypoint(950, 188, "G");
        this.airspace.newWaypoint(1050, 272, "H");
        this.airspace.newWaypoint(900, 420, "I");
        this.airspace.newWaypoint(240, 250, "J");
        this.airspace.newEntryPoint(150, 400);
        this.airspace.newEntryPoint(1200, 200);
        this.airspace.newEntryPoint(600, 0);
        this.airspace.newExitPoint(800, 0, "1");
        this.airspace.newExitPoint(150, 200, "2");
        this.airspace.newExitPoint(1200, 300, "3");
        this.flight1 = new Flight(this.airspace, 1);
        this.flight2 = new Flight(this.airspace, 4);
        this.airspace.addFlight(this.flight1);
        this.airspace.addFlight(this.flight2);
        this.flight1.setX(0.0);
        this.flight2.setX(25.0);
        this.flight1.setY(0.0);
        this.flight2.setY(25.0);
        this.flight1.setAltitude(27000);
        this.flight2.setAltitude(27000);
    }

    @Test
    public void lateralDistanceBetweenFLightsTest() {
        Assert.assertTrue(this.separationRules.lateralDistanceBetweenFlights(this.flight1, this.flight2) >= 0.0);
    }

    @Test
    public void verticalDistanceBetweenFlightsTest() {
        Assert.assertTrue(this.separationRules.verticalDistanceBetweenFlights(this.flight1, this.flight2) >= 0);
    }

    @Test
    public void checkViolationTrueTest() {
        this.flight1.setX(1.0);
        this.flight2.setX(1.0);
        this.flight1.setY(1.0);
        this.flight2.setY(1.0);
        this.separationRules.checkViolation(this.airspace);
        Assert.assertTrue(this.separationRules.getGameOverViolation());
    }

    @Test
    public void checkViolationFalseVerticalTest() {
        this.flight1.setX(1.0);
        this.flight2.setX(1.0);
        this.flight1.setY(1000.0);
        this.flight2.setY(5000.0);
        this.separationRules.checkViolation(this.airspace);
        Assert.assertFalse(this.separationRules.getGameOverViolation());
    }

    @Test
    public void checkViolationFalseLateralTest() {
        this.flight1.setX(1000.0);
        this.flight2.setX(1.0);
        this.flight1.setY(1000.0);
        this.flight2.setY(1000.0);
        this.separationRules.checkViolation(this.airspace);
        Assert.assertFalse(this.separationRules.getGameOverViolation());
    }
}

