/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import logicClasses.Point;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.LoadingList;
import util.DeferredFile;

public class Airport
extends Point {
    private static Image airportImage;
    private int runwayHeading;

    Airport(double x, double y, int runwayHeading, String name) {
        super(x, y, name);
        this.runwayHeading = runwayHeading;
    }

    public static void init() throws SlickException {
        if (airportImage == null) {
            LoadingList.get().add(new DeferredFile("res/graphics/airport.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    airportImage = new Image(filename);
                }
            });
        }
    }

    public void render(Graphics g) throws SlickException {
        airportImage.setRotation(this.runwayHeading);
        airportImage.drawCentered((int)this.x, (int)this.y);
        g.drawString(this.pointRef, (int)this.x - 14, (int)this.y - 10);
    }

    public String toString() {
        return "Airport " + this.pointRef + " located at (" + this.x + ", " + this.y + ")";
    }

    public int getRunwayHeading() {
        return this.runwayHeading;
    }

    public int getInverseRunwayHeading() {
        if (this.runwayHeading < 180) {
            return this.runwayHeading + 180;
        }
        return this.runwayHeading - 180;
    }
}

