/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import logicClasses.Airport;
import logicClasses.EntryPoint;
import logicClasses.ExitPoint;
import logicClasses.Flight;
import logicClasses.Point;
import logicClasses.ScoreTracking;
import logicClasses.SeparationRules;
import logicClasses.Waypoint;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.LoadingList;
import states.MultiPlayState;
import util.DeferredFile;

public class Airspace {
    private static Image backgroundImage;
    private static Random rand;
    private static final int MAX_FLIGHTS = 10;
    private static final int DIFFICULTY_INCREASE_INTERVAL = 900;
    private static final int INITIAL_CHANCE_OF_NEW_FLIGHT = 400;
    private static final int HANDOVER_DELAY = 300;
    private int chanceOfNewFlight = 400;
    private int numberOfGameLoops = 0;
    private int numberOfGameLoopsSinceLastFlightAdded = 0;
    private int numberOfGameLoopsWhenDifficultyIncreases = 900;
    private int loopsUntilRedAbleToHandover = 0;
    private int loopsUntilBlueAbleToHandover = 0;
    private List<Flight> listOfFlightsInAirspace = new ArrayList<Flight>();
    private List<Waypoint> listOfWayppoints = new ArrayList<Waypoint>();
    private List<EntryPoint> listOfEntryPoints = new ArrayList<EntryPoint>();
    private List<ExitPoint> listOfExitPoints = new ArrayList<ExitPoint>();
    private List<Airport> listOfAirports = new ArrayList<Airport>();
    private ScoreTracking score = new ScoreTracking();
    private ScoreTracking redScore = new ScoreTracking();
    private ScoreTracking blueScore = new ScoreTracking();
    private SeparationRules separationRules;
    private int difficultyValueOfGame;
    private boolean isMultiplayer;

    public static void init() throws SlickException {
        if (backgroundImage == null) {
            LoadingList.get().add(new DeferredFile("res/graphics/background.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    backgroundImage = new Image(filename);
                }
            });
        }
    }

    public Airspace(boolean multiplayer) {
        this.isMultiplayer = multiplayer;
    }

    public static double distanceBetween(Point a, Point b) {
        return Math.hypot(b.getX() - a.getX(), b.getY() - a.getY());
    }

    public static double distanceBetween(Flight a, Flight b) {
        return Math.hypot(b.getX() - a.getX(), b.getY() - a.getY());
    }

    public static double normalizeAngle(double angle) {
        return (angle % 360.0 + 360.0) % 360.0;
    }

    public void resetAirspace() {
        this.listOfFlightsInAirspace = new ArrayList<Flight>();
        this.numberOfGameLoopsSinceLastFlightAdded = 0;
        this.numberOfGameLoops = 0;
        this.numberOfGameLoopsWhenDifficultyIncreases = 900;
        this.chanceOfNewFlight = 400;
        this.separationRules.setGameOverViolation(false);
        this.score = new ScoreTracking();
        this.redScore = new ScoreTracking();
        this.blueScore = new ScoreTracking();
    }

    public void createAndSetSeparationRules() {
        this.separationRules = new SeparationRules(this.difficultyValueOfGame);
    }

    public boolean newWaypoint(int x, int y, String name) {
        Waypoint tmpWp;
        return x < 1250 && x > 0 && y < 650 && y > -50 && this.addWaypoint(tmpWp = new Waypoint(x, y, name));
    }

    public void newAirport(int x, int y, int runwayHeading, String name) {
        this.listOfAirports.add(new Airport(x, y, runwayHeading, name));
        this.addExitPoint(new ExitPoint(x, y, name));
        int airportEntryX = x - (int)(140.0 * Math.sin(Math.toRadians(runwayHeading)));
        int airportEntryY = y + (int)(140.0 * Math.cos(Math.toRadians(runwayHeading)));
        this.addEntryPoint(new EntryPoint(airportEntryX, airportEntryY));
    }

    public boolean newExitPoint(int x, int y, String name) {
        return x < 1250 && x > -50 && y < 650 && y > -50 && this.addExitPoint(new ExitPoint(x, y, name));
    }

    public boolean newEntryPoint(int x, int y) {
        return x < 1250 && x > -50 && y < 650 && y > -50 && this.addEntryPoint(new EntryPoint(x, y));
    }

    public boolean newFlight() throws SlickException {
        int checkNumber;
        if (this.listOfFlightsInAirspace.size() < 10 && (this.numberOfGameLoopsSinceLastFlightAdded >= 300 || this.listOfFlightsInAirspace.isEmpty()) && (checkNumber = this.numberOfGameLoopsSinceLastFlightAdded >= 1200 || this.listOfFlightsInAirspace.isEmpty() ? rand.nextInt(Math.min(100, this.chanceOfNewFlight)) : rand.nextInt(this.chanceOfNewFlight)) == 1) {
            Flight tempFlight = new Flight(this);
            if (!this.isMultiplayer) {
                tempFlight.setOwner("single");
            } else if (rand.nextBoolean()) {
                tempFlight.setOwner("red");
            } else {
                tempFlight.setOwner("blue");
            }
            double heading = tempFlight.getFlightPlan().getEntryPoint().isRunway() ? (tempFlight.getX() == this.listOfAirports.get(0).getX() ? (double)this.listOfAirports.get(0).getRunwayHeading() : (double)this.listOfAirports.get(1).getRunwayHeading()) : tempFlight.calculateHeadingToFirstWaypoint(tempFlight.getFlightPlan().getPointByIndex(0).getX(), tempFlight.getFlightPlan().getPointByIndex(0).getY());
            tempFlight.setTargetHeading(heading);
            tempFlight.setCurrentHeading(heading);
            if (this.addFlight(tempFlight)) {
                this.numberOfGameLoopsSinceLastFlightAdded = 0;
                return true;
            }
        }
        return false;
    }

    public boolean checkIfFlightHasLeftAirspace(Flight flight) {
        return flight.getX() > 1250.0 || flight.getX() < -50.0 || flight.getY() > 650.0 || flight.getY() < -50.0;
    }

    public void increaseDifficulty() {
        this.numberOfGameLoopsWhenDifficultyIncreases += 900;
        if (this.chanceOfNewFlight - 25 > 0) {
            this.chanceOfNewFlight -= 25;
        }
        if (this.isMultiplayer) {
            this.redScore.applyTimeBonus();
            this.blueScore.applyTimeBonus();
        } else {
            this.score.applyTimeBonus();
        }
    }

    public void update() {
        ++this.numberOfGameLoops;
        ++this.numberOfGameLoopsSinceLastFlightAdded;
        if (this.isMultiplayer) {
            if (this.loopsUntilRedAbleToHandover > 0) {
                --this.loopsUntilRedAbleToHandover;
            }
            if (this.loopsUntilBlueAbleToHandover > 0) {
                --this.loopsUntilBlueAbleToHandover;
            }
        }
        if (this.numberOfGameLoops >= this.numberOfGameLoopsWhenDifficultyIncreases) {
            this.increaseDifficulty();
        }
        Iterator<Flight> i = this.listOfFlightsInAirspace.iterator();
        while (i.hasNext()) {
            Flight f = i.next();
            f.update(this.getScore(f.getOwner()));
            if (f.isLanding() && f.isGrounded() && f.getVelocity() == 0.0) {
                i.remove();
                continue;
            }
            if (f.getFlightPlan().getCurrentRoute().size() == 0) {
                i.remove();
                continue;
            }
            if (!this.checkIfFlightHasLeftAirspace(f)) continue;
            this.getScore(f.getOwner()).applyFlightLossPenalty();
            i.remove();
        }
        this.separationRules.update(this);
    }

    public void render(Graphics g) throws SlickException {
        backgroundImage.draw(0.0f, 0.0f);
        for (Airport airport : this.listOfAirports) {
            airport.render(g);
        }
        for (Waypoint waypoint : this.listOfWayppoints) {
            waypoint.render(g);
        }
        for (ExitPoint exitPoint : this.listOfExitPoints) {
            exitPoint.render(g);
        }
        for (EntryPoint entryPoint : this.listOfEntryPoints) {
            entryPoint.render(g);
        }
        for (Flight flight : this.listOfFlightsInAirspace) {
            flight.render(g);
        }
        this.separationRules.render(g, this);
        if (!this.isRedAbleToHandover()) {
            int handoverPercentRemaining = (int)((double)this.loopsUntilRedAbleToHandover / 300.0 * 100.0);
            g.setColor(MultiPlayState.RED_COLOR);
            g.fillRect(1080.0f, 525.0f, handoverPercentRemaining, 20.0f);
            g.setColor(Color.white);
            g.drawRect(1080.0f, 525.0f, 100.0f, 20.0f);
        }
        if (!this.isBlueAbleToHandover()) {
            int handoverPercentRemaining = (int)((double)this.loopsUntilBlueAbleToHandover / 300.0 * 100.0);
            g.setColor(MultiPlayState.BLUE_COLOR);
            g.fillRect(1080.0f, 560.0f, handoverPercentRemaining, 20.0f);
            g.setColor(Color.white);
            g.drawRect(1080.0f, 560.0f, 100.0f, 20.0f);
        }
    }

    public List<Flight> getListOfFlights() {
        return this.listOfFlightsInAirspace;
    }

    public boolean isFlightWithOwner(String owner) {
        return !this.getListOfFlightsWithOwner(owner).isEmpty();
    }

    public List<Flight> getListOfFlightsWithOwner(String owner) {
        ArrayList<Flight> toReturn = new ArrayList<Flight>();
        for (Flight f : this.listOfFlightsInAirspace) {
            if (f.getOwner() != owner) continue;
            toReturn.add(f);
        }
        return toReturn;
    }

    public List<Waypoint> getListOfWaypoints() {
        return this.listOfWayppoints;
    }

    public List<EntryPoint> getListOfEntryPoints() {
        return this.listOfEntryPoints;
    }

    public List<ExitPoint> getListOfExitPoints() {
        return this.listOfExitPoints;
    }

    public boolean addWaypoint(Waypoint waypoint) {
        if (this.listOfWayppoints.contains(waypoint)) {
            return false;
        }
        this.listOfWayppoints.add(waypoint);
        return true;
    }

    public boolean addEntryPoint(EntryPoint entrypoint) {
        if (this.listOfEntryPoints.contains(entrypoint)) {
            return false;
        }
        this.listOfEntryPoints.add(entrypoint);
        return true;
    }

    public boolean addExitPoint(ExitPoint exitpoint) {
        if (this.listOfExitPoints.contains(exitpoint)) {
            return false;
        }
        this.listOfExitPoints.add(exitpoint);
        return true;
    }

    public boolean addFlight(Flight f) {
        if (this.listOfFlightsInAirspace.contains(f) && this.listOfFlightsInAirspace.size() > 9) {
            return false;
        }
        for (Flight e : this.listOfFlightsInAirspace) {
            if (Math.abs(e.getAltitude() - f.getAltitude()) > 999 || !(Airspace.distanceBetween(e, f) <= 100.0)) continue;
            return false;
        }
        this.listOfFlightsInAirspace.add(f);
        return true;
    }

    public void removeSpecificFlight(Flight flight) {
        this.listOfFlightsInAirspace.remove(flight);
    }

    public SeparationRules getSeparationRules() {
        return this.separationRules;
    }

    public ScoreTracking getScore(String player) {
        if (player == "red") {
            return this.redScore;
        }
        if (player == "blue") {
            return this.blueScore;
        }
        return this.score;
    }

    public void setDifficultyValueOfGame(int i) {
        this.difficultyValueOfGame = i;
    }

    public int getDifficultyValueOfGame() {
        return this.difficultyValueOfGame;
    }

    public int getNumberOfGameLoops() {
        return this.numberOfGameLoops;
    }

    public int getNumberOfGameLoopsWhenDifficultyIncreases() {
        return this.numberOfGameLoopsWhenDifficultyIncreases;
    }

    public List<Airport> getListOfAirports() {
        return this.listOfAirports;
    }

    public void resetRedHandoverCountdown() {
        this.loopsUntilRedAbleToHandover = 300;
    }

    public void resetBlueHandoverCountdown() {
        this.loopsUntilBlueAbleToHandover = 300;
    }

    public boolean isRedAbleToHandover() {
        return this.loopsUntilRedAbleToHandover == 0;
    }

    public boolean isBlueAbleToHandover() {
        return this.loopsUntilBlueAbleToHandover == 0;
    }

    public String toString() {
        return "Airspace: " + this.listOfAirports.toString();
    }

    static {
        rand = new Random();
    }
}

