/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.util.ArrayList;
import java.util.List;
import logicClasses.Airspace;
import logicClasses.Flight;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Input;
import org.newdawn.slick.SlickException;
import states.MultiPlayState;
import util.KeyBindings;

public class Controls {
    private KeyBindings myKeys;
    private String myPlayer;
    private Flight selectedFlight;

    public Controls(KeyBindings keys, String player) {
        this.myPlayer = player;
        this.myKeys = keys;
        this.selectedFlight = null;
    }

    public void render(Graphics g) throws SlickException {
        if (this.selectedFlight != null) {
            if (this.myPlayer == "red") {
                g.setColor(MultiPlayState.RED_COLOR);
            } else if (this.myPlayer == "blue") {
                g.setColor(MultiPlayState.BLUE_COLOR);
            } else {
                g.setColor(Color.white);
            }
            g.drawOval((int)this.selectedFlight.getX() - 14, (int)this.selectedFlight.getY() - 14, 28.0f, 28.0f);
            this.selectedFlight.getFlightPlan().render(g);
        }
    }

    public void update(GameContainer gc, Airspace airspace) {
        if (!airspace.getListOfFlightsWithOwner(this.myPlayer).contains(this.selectedFlight)) {
            this.selectedFlight = null;
        }
        if (this.selectedFlight == null && airspace.isFlightWithOwner(this.myPlayer)) {
            this.selectedFlight = airspace.getListOfFlightsWithOwner(this.myPlayer).get(0);
        }
        if (this.selectedFlight == null) {
            return;
        }
        Input input = gc.getInput();
        if (this.selectedFlight.isCommandable()) {
            if (input.isKeyPressed(this.myKeys.get("up"))) {
                if (this.selectedFlight.getTargetAltitude() <= 4000) {
                    this.selectedFlight.setTargetAltitude(this.selectedFlight.getTargetAltitude() + 1000);
                }
            } else if (input.isKeyPressed(this.myKeys.get("down")) && this.selectedFlight.getTargetAltitude() >= 2000) {
                this.selectedFlight.setTargetAltitude(this.selectedFlight.getTargetAltitude() - 1000);
            }
            if (input.isKeyDown(this.myKeys.get("left"))) {
                this.selectedFlight.turnFlightLeft(2);
            } else if (input.isKeyDown(this.myKeys.get("right"))) {
                this.selectedFlight.turnFlightRight(2);
            }
            if (input.isKeyPressed(this.myKeys.get("accelerate"))) {
                if (this.selectedFlight.getTargetVelocity() <= 350.0) {
                    this.selectedFlight.setTargetVelocity(this.selectedFlight.getTargetVelocity() + 50.0);
                }
            } else if (input.isKeyPressed(this.myKeys.get("decelerate")) && this.selectedFlight.getTargetVelocity() >= 250.0) {
                this.selectedFlight.setTargetVelocity(this.selectedFlight.getTargetVelocity() - 50.0);
            }
        }
        if (input.isKeyPressed(this.myKeys.get("toggle_forwards"))) {
            List<Object> listOfFlights = new ArrayList();
            listOfFlights = airspace.getListOfFlightsWithOwner(this.myPlayer);
            int indexOfCurrentFlight = listOfFlights.indexOf(this.selectedFlight);
            this.selectedFlight = indexOfCurrentFlight == listOfFlights.size() - 1 ? (Flight)listOfFlights.get(0) : (Flight)listOfFlights.get(indexOfCurrentFlight + 1);
        } else if (input.isKeyPressed(this.myKeys.get("toggle_backwards"))) {
            List<Object> listOfFlights = new ArrayList();
            listOfFlights = airspace.getListOfFlightsWithOwner(this.myPlayer);
            int indexOfCurrentFlight = listOfFlights.indexOf(this.selectedFlight);
            this.selectedFlight = indexOfCurrentFlight == 0 ? (Flight)listOfFlights.get(listOfFlights.size() - 1) : (Flight)listOfFlights.get(indexOfCurrentFlight - 1);
        }
        if (input.isKeyPressed(this.myKeys.get("airport"))) {
            if (this.selectedFlight.isGrounded()) {
                this.selectedFlight.takeOff();
            } else if (this.selectedFlight.isLanding()) {
                this.selectedFlight.abortLanding();
            } else {
                this.selectedFlight.land();
            }
        }
        if ((this.myPlayer == "red" || this.myPlayer == "blue") && input.isKeyPressed(this.myKeys.get("handover"))) {
            this.selectedFlight.handOver(airspace.getScore(this.selectedFlight.getOwner()));
        }
    }
}

