/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import logicClasses.Point;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.LoadingList;
import util.DeferredFile;

public class EntryPoint
extends Point {
    private static Image entryPointTop;
    private static Image entryPointRight;
    private static Image entryPointLeft;

    public EntryPoint(double x, double y) {
        super(x, y);
    }

    public static void init() throws SlickException {
        LoadingList loading = LoadingList.get();
        if (entryPointTop == null) {
            loading.add(new DeferredFile("res/graphics/entrypoint.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    entryPointTop = new Image(filename);
                    entryPointRight = entryPointTop.copy();
                    entryPointRight.setRotation(90.0f);
                    entryPointLeft = entryPointTop.copy();
                    entryPointLeft.setRotation(270.0f);
                }
            });
        }
    }

    public void render(Graphics g) throws SlickException {
        if (this.y == 0.0) {
            entryPointTop.draw((int)this.x - 20, (int)this.y);
        } else if (this.x == 0.0) {
            entryPointLeft.draw((int)this.x, (int)this.y - 20);
        } else if (this.x == 1200.0) {
            entryPointRight.draw((int)this.x - 40, (int)this.y - 20);
        }
    }

    public boolean isRunway() {
        return this.x != 0.0 && this.x != 1200.0 && this.y != 0.0 && this.y != 600.0;
    }
}

