/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import logicClasses.Point;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.LoadingList;
import util.DeferredFile;

public class ExitPoint
extends Point {
    private static Image exitPointTop;
    private static Image exitPointRight;
    private static Image exitPointLeft;

    public ExitPoint(double x, double y, String name) {
        super(x, y, name);
    }

    public static void init() throws SlickException {
        LoadingList loading = LoadingList.get();
        if (exitPointTop == null) {
            loading.add(new DeferredFile("res/graphics/exitpoint.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    exitPointTop = new Image(filename);
                    exitPointRight = exitPointTop.copy();
                    exitPointRight.setRotation(90.0f);
                    exitPointLeft = exitPointTop.copy();
                    exitPointLeft.setRotation(270.0f);
                }
            });
        }
    }

    public void render(Graphics g) throws SlickException {
        g.setColor(Color.white);
        if (this.y == 0.0) {
            exitPointTop.draw((int)this.x - 20, (int)this.y);
            g.drawString(this.pointRef, (int)this.x - 15, (int)this.y);
        } else if (this.x == 0.0) {
            exitPointLeft.draw((int)this.x, (int)this.y - 20);
            g.drawString(this.pointRef, (int)this.x, (int)this.y - 7);
        } else if (this.x == 1200.0) {
            exitPointRight.draw((int)this.x - 40, (int)this.y - 20);
            g.drawString(this.pointRef, (int)this.x - 35, (int)this.y - 7);
        }
    }

    public boolean isRunway() {
        return this.x != 0.0 && this.x != 1200.0 && this.y != 0.0 && this.y != 600.0;
    }
}

