/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.util.Random;
import logicClasses.Airport;
import logicClasses.Airspace;
import logicClasses.ExitPoint;
import logicClasses.FlightPlan;
import logicClasses.Point;
import logicClasses.ScoreTracking;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.LoadingList;
import util.DeferredFile;

public class Flight {
    private static Image whiteFlightImage;
    private static Image redFlightImage;
    private static Image blueFlightImage;
    private static Image shadowImage;
    private static final Random rand;
    private static final double GAME_SCALE = 0.001;
    public static final int MIN_VELOCITY = 200;
    public static final int MAX_VELOCITY = 400;
    private static final int STALL_VELOCITY = 80;
    public static final int MIN_ALTITUDE = 1000;
    public static final int MAX_ALTITUDE = 5000;
    private static final int RADIUS = 30;
    private static final double ACCEL_RATE = 0.3333333333333333;
    private static final double CLIMB_RATE = 1.0;
    private static final double TURN_RATE = 0.5;
    private double x = 0.0;
    private double y = 0.0;
    private double velocity;
    private double targetVelocity;
    private double currentHeading;
    private double targetHeading;
    private int currentAltitude;
    private int targetAltitude;
    private boolean turningRight = false;
    private boolean turningLeft = false;
    private Airspace airspace;
    private FlightPlan flightPlan;
    private int closestDistance = Integer.MAX_VALUE;
    private int distanceFromWaypoint;
    private boolean takingOff = false;
    private boolean landing = false;
    private String owner;

    public Flight(Airspace airspace) {
        this.airspace = airspace;
        this.flightPlan = new FlightPlan(airspace, this);
        this.targetAltitude = this.currentAltitude = this.generateAltitude();
    }

    public static void init() throws SlickException {
        LoadingList loading = LoadingList.get();
        if (whiteFlightImage == null) {
            loading.add(new DeferredFile("res/graphics/flight.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    whiteFlightImage = new Image(filename);
                }
            });
        }
        if (shadowImage == null) {
            loading.add(new DeferredFile("res/graphics/flight_shadow.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    shadowImage = new Image(filename);
                }
            });
        }
        if (redFlightImage == null) {
            loading.add(new DeferredFile("res/graphics/flight_red.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    redFlightImage = new Image(filename);
                }
            });
        }
        if (blueFlightImage == null) {
            loading.add(new DeferredFile("res/graphics/flight_blue.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    blueFlightImage = new Image(filename);
                }
            });
        }
    }

    public int generateAltitude() {
        if (this.getFlightPlan().getEntryPoint().isRunway()) {
            return 0;
        }
        int check = rand.nextInt(2);
        return 1000 + (check + 1) * 1000;
    }

    public double calculateHeadingToFirstWaypoint(double desX, double desY) {
        return Airspace.normalizeAngle(Math.toDegrees(Math.atan2(desY - this.y, desX - this.x)) + 90.0);
    }

    public void turnFlightLeft(int degreeTurnedBy) {
        this.turningRight = false;
        this.turningLeft = true;
        this.targetHeading = Airspace.normalizeAngle(Math.round(this.currentHeading) - (long)degreeTurnedBy);
    }

    public void turnFlightRight(int degreeTurnedBy) {
        this.turningLeft = false;
        this.turningRight = true;
        this.targetHeading = Airspace.normalizeAngle(Math.round(this.currentHeading) + (long)degreeTurnedBy);
    }

    public void giveHeading(int newHeading) {
        this.turningRight = false;
        this.turningLeft = false;
        this.targetHeading = Airspace.normalizeAngle(newHeading);
    }

    public void takeOff() {
        this.takingOff = true;
        this.setTargetVelocity(300.0);
        this.setTargetAltitude(1000);
    }

    public void land() {
        if (!this.landing && this.currentAltitude <= 1000 && this.velocity <= 200.0) {
            for (Airport a : this.airspace.getListOfAirports()) {
                if (!this.checkIfAtAirport(a) || !this.checkHeadingCorrectForAirport(a)) continue;
                this.landing = true;
                this.setTargetAltitude(0);
                this.setTargetVelocity(80.0);
                if (Flight.withinTolerance(this.currentHeading, a.getRunwayHeading(), 10.0)) {
                    this.giveHeading(a.getRunwayHeading());
                    break;
                }
                this.giveHeading(a.getInverseRunwayHeading());
                break;
            }
        }
    }

    public boolean isReadyToLand() {
        if (!this.landing && !this.isGrounded() && !this.takingOff && this.currentAltitude <= 1000 && this.velocity <= 200.0 && this.targetAltitude <= 1000 && this.targetVelocity <= 200.0) {
            for (Airport a : this.airspace.getListOfAirports()) {
                if (!this.checkIfAtAirport(a) || !this.checkHeadingCorrectForAirport(a)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkHeadingCorrectForAirport(Airport a) {
        return Flight.withinTolerance(this.currentHeading, a.getRunwayHeading(), 10.0) || Flight.withinTolerance(this.currentHeading, a.getInverseRunwayHeading(), 10.0);
    }

    private boolean checkIfAtAirport(Airport airport) {
        if (airport.getRunwayHeading() == 90 && Math.abs(Math.round(this.x) - Math.round(airport.getX())) <= 150L && Math.abs(Math.round(this.y) - Math.round(airport.getY())) <= 15L) {
            return true;
        }
        return airport.getRunwayHeading() == 0 && Math.abs(Math.round(this.x) - Math.round(airport.getX())) <= 15L && Math.abs(Math.round(this.y) - Math.round(airport.getY())) <= 150L;
    }

    private static boolean withinTolerance(double a, double b, double tolerance) {
        return Math.abs(a - b) <= tolerance || Math.abs(a - 360.0 - b) <= tolerance || Math.abs(a + 360.0 - b) <= tolerance;
    }

    public void abortLanding() {
        if (this.landing) {
            this.landing = false;
            if (this.currentAltitude < 1000 && this.targetAltitude < 1000 || this.targetAltitude < 1000) {
                this.targetAltitude = 1000;
            }
            if (this.velocity < 200.0 && this.targetVelocity < 200.0 || this.targetVelocity < 200.0) {
                this.targetVelocity = 200.0;
            }
        }
    }

    public void handOver(ScoreTracking st) {
        if (this.owner == "red" && this.airspace.isRedAbleToHandover()) {
            this.owner = "blue";
            this.airspace.resetRedHandoverCountdown();
            st.applyFlightLossPenalty();
        } else if (this.owner == "blue" && this.airspace.isBlueAbleToHandover()) {
            this.owner = "red";
            this.airspace.resetBlueHandoverCountdown();
            st.applyFlightLossPenalty();
        }
    }

    public void updateXYCoordinates() {
        this.x += this.velocity * Math.sin(Math.toRadians(this.currentHeading)) * 0.001;
        this.y -= this.velocity * Math.cos(Math.toRadians(this.currentHeading)) * 0.001;
    }

    public void updateAltitude() {
        if (this.currentAltitude > this.targetAltitude && !this.takingOff) {
            this.currentAltitude = (int)((double)this.currentAltitude - 1.0);
        } else if (this.currentAltitude < this.targetAltitude && !this.takingOff) {
            this.currentAltitude = (int)((double)this.currentAltitude + 1.0);
        }
    }

    public void updateCurrentHeading() {
        if (Math.round(this.targetHeading) != Math.round(this.currentHeading)) {
            if (!this.turningRight && !this.turningLeft) {
                if (Math.abs(this.targetHeading - this.currentHeading) == 180.0) {
                    this.turningRight = true;
                } else if (this.currentHeading + 180.0 <= 359.0) {
                    if (this.targetHeading < this.currentHeading + 180.0 && this.targetHeading > this.currentHeading) {
                        this.turningRight = true;
                    } else {
                        this.turningLeft = true;
                    }
                } else if (this.targetHeading > this.currentHeading - 180.0 && this.targetHeading < this.currentHeading) {
                    this.turningLeft = true;
                } else {
                    this.turningRight = true;
                }
            }
            if (this.turningRight) {
                this.currentHeading += 0.5;
                if (Math.round(this.currentHeading) >= 360L && this.targetHeading != 360.0) {
                    this.currentHeading = 0.0;
                }
            }
            if (this.turningLeft) {
                this.currentHeading -= 0.5;
                if (Math.round(this.currentHeading) <= 0L && this.targetHeading != 0.0) {
                    this.currentHeading = 360.0;
                }
            }
        }
    }

    public void updateVelocity() {
        double dv = 0.01 * (this.targetVelocity - this.velocity);
        dv = this.targetVelocity > this.velocity ? Math.min(dv, 0.3333333333333333) : Math.max(dv, -0.3333333333333333);
        this.velocity += dv;
        if (Math.abs(this.targetVelocity - this.velocity) < 0.5) {
            this.velocity = this.targetVelocity;
        }
        if (this.takingOff && this.velocity > 80.0) {
            this.takingOff = false;
        }
        if (this.landing && this.isGrounded() && this.targetVelocity != 0.0) {
            this.targetVelocity = 0.0;
        }
    }

    public void update(ScoreTracking score) {
        this.updateVelocity();
        this.updateCurrentHeading();
        this.updateXYCoordinates();
        this.updateAltitude();
        this.flightPlan.update(score);
    }

    public void render(Graphics g) throws SlickException {
        float shadowScale = (float)(36 - this.currentAltitude / 1000) / 10.0f;
        shadowImage.setRotation((int)this.currentHeading);
        shadowImage.draw((float)((int)this.x - 35), (float)((int)this.y), shadowScale);
        if (this.owner == "red") {
            redFlightImage.setRotation((int)this.currentHeading);
            redFlightImage.draw((int)this.x - 10, (int)this.y - 10);
        } else if (this.owner == "blue") {
            blueFlightImage.setRotation((int)this.currentHeading);
            blueFlightImage.draw((int)this.x - 10, (int)this.y - 10);
        } else {
            whiteFlightImage.setRotation((int)this.currentHeading);
            whiteFlightImage.draw((int)this.x - 10, (int)this.y - 10);
        }
        g.setColor(Color.white);
        if (!this.flightPlan.getCurrentRoute().isEmpty()) {
            g.drawString("Aim: " + this.flightPlan.getPointByIndex(0).getPointRef(), (int)this.x + 18, (int)this.y - 27);
        }
        g.drawString(this.currentAltitude + "ft", (int)this.x + 17, (int)this.y - 9);
        g.drawString(Math.round(this.velocity) + "mph", (int)this.x + 17, (int)this.y + 9);
        if (this.isReadyToLand()) {
            g.drawString("Ready to land", (int)this.x + 17, (int)this.y + 27);
        }
    }

    public boolean checkIfFlightAtWaypoint(Point waypoint) {
        this.distanceFromWaypoint = (int)Math.hypot(this.x - waypoint.getX(), this.y - waypoint.getY());
        if (this.closestDistance > this.distanceFromWaypoint) {
            this.closestDistance = this.distanceFromWaypoint;
        }
        if (this.distanceFromWaypoint <= 30 && this.closestDistance < this.distanceFromWaypoint) {
            if (waypoint instanceof ExitPoint && ((ExitPoint)waypoint).isRunway()) {
                return this.currentAltitude == 0;
            }
            return true;
        }
        return false;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double x) {
        this.x = x;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double y) {
        this.y = y;
    }

    public double getCurrentHeading() {
        return this.currentHeading;
    }

    public void setCurrentHeading(double currentHeading) {
        this.currentHeading = currentHeading;
    }

    public double getTargetHeading() {
        return this.targetHeading;
    }

    public void setTargetHeading(double targetHeading) {
        this.targetHeading = targetHeading;
    }

    public int getTargetAltitude() {
        return this.targetAltitude;
    }

    public void setTargetAltitude(int targetAltitude) {
        this.targetAltitude = targetAltitude;
    }

    public int getAltitude() {
        return this.currentAltitude;
    }

    public void setAltitude(int altitude) {
        this.currentAltitude = altitude;
    }

    public boolean isGrounded() {
        return this.getAltitude() == 0;
    }

    public boolean isCommandable() {
        return !this.isGrounded() && !this.landing;
    }

    public boolean isLanding() {
        return this.landing;
    }

    public boolean getTurningRight() {
        return this.turningRight;
    }

    public boolean getTurningLeft() {
        return this.turningLeft;
    }

    public int getClosestDistanceFromWaypoint() {
        return this.closestDistance;
    }

    public void resetClosestDistanceFromWaypoint() {
        this.closestDistance = Integer.MAX_VALUE;
    }

    public String toString() {
        return "Flight at (" + this.x + ", " + this.y + ")";
    }

    public int getCurrentAltitude() {
        return this.currentAltitude;
    }

    public void setCurrentAltitude(int currentAltitude) {
        this.currentAltitude = currentAltitude;
    }

    public double getVelocity() {
        return this.velocity;
    }

    public void setVelocity(double velocity) {
        this.velocity = velocity;
    }

    public void setTargetVelocity(double velocity) {
        this.targetVelocity = velocity;
    }

    public double getTargetVelocity() {
        return this.targetVelocity;
    }

    public FlightPlan getFlightPlan() {
        return this.flightPlan;
    }

    public Airspace getAirspace() {
        return this.airspace;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean getLanding() {
        return this.landing;
    }

    static {
        rand = new Random();
    }
}

