/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import logicClasses.Airspace;
import logicClasses.EntryPoint;
import logicClasses.ExitPoint;
import logicClasses.Flight;
import logicClasses.Point;
import logicClasses.ScoreTracking;
import logicClasses.Waypoint;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public class FlightPlan {
    private static final Color RED_COLOR = new Color(197, 131, 138);
    private static final Color BLUE_COLOR = new Color(141, 191, 244);
    private static final Random rand = new Random();
    private EntryPoint entryPoint;
    private ExitPoint exitPoint;
    private List<Point> currentRoute = new ArrayList<Point>();
    private List<Point> waypointsAlreadyVisited = new ArrayList<Point>();
    private Flight flight;
    private int closestDistance;

    public FlightPlan(Airspace airspace, Flight flight) {
        this.flight = flight;
        this.entryPoint = this.generateEntryPoint(airspace);
        flight.setVelocity(this.generateVelocity());
        flight.setTargetVelocity(flight.getVelocity());
        this.currentRoute = this.buildRoute(airspace, this.entryPoint);
    }

    public EntryPoint generateEntryPoint(Airspace airspace) {
        int randomNumber = rand.nextInt(airspace.getListOfEntryPoints().size());
        this.flight.setX(airspace.getListOfEntryPoints().get(randomNumber).getX());
        this.flight.setY(airspace.getListOfEntryPoints().get(randomNumber).getY());
        return airspace.getListOfEntryPoints().get(randomNumber);
    }

    public ArrayList<Point> buildRoute(Airspace airspace, EntryPoint entryPoint) {
        ArrayList<Point> tempRoute = new ArrayList<Point>();
        if (!airspace.getListOfWaypoints().isEmpty() && !airspace.getListOfExitPoints().isEmpty()) {
            ArrayList<ExitPoint> shuffledExitPointList = new ArrayList<ExitPoint>(airspace.getListOfExitPoints());
            Collections.shuffle(shuffledExitPointList);
            for (ExitPoint exitPoint : shuffledExitPointList) {
                if (entryPoint.getY() == 0.0 && exitPoint.getY() == 0.0 || entryPoint.getX() == 0.0 && exitPoint.getX() == 0.0 || entryPoint.getX() == 1200.0 && exitPoint.getX() == 1200.0 || entryPoint.isRunway() && exitPoint.isRunway()) continue;
                tempRoute.add(exitPoint);
                this.exitPoint = exitPoint;
                break;
            }
            ArrayList<Waypoint> shuffledWaypointList = new ArrayList<Waypoint>(airspace.getListOfWaypoints());
            Collections.shuffle(shuffledWaypointList);
            block1: for (Waypoint v : shuffledWaypointList) {
                if (tempRoute.size() == 3) break;
                for (Waypoint w : shuffledWaypointList) {
                    if (v == w || !(Airspace.distanceBetween(v, this.exitPoint) > Airspace.distanceBetween(w, this.exitPoint)) || !(Airspace.distanceBetween(entryPoint, v) < Airspace.distanceBetween(entryPoint, w))) continue;
                    tempRoute.add(0, v);
                    tempRoute.add(1, w);
                    continue block1;
                }
            }
        }
        return tempRoute;
    }

    public int generateVelocity() {
        if (this.entryPoint.isRunway()) {
            return 0;
        }
        return rand.nextInt(4) * 50 + 200;
    }

    public void update(ScoreTracking score) {
        int waypointScore = 0;
        if (!this.currentRoute.isEmpty()) {
            if (this.flight.checkIfFlightAtWaypoint(this.currentRoute.get(0))) {
                this.waypointsAlreadyVisited.add(this.currentRoute.get(0));
                this.closestDistance = this.flight.getClosestDistanceFromWaypoint();
                this.flight.resetClosestDistanceFromWaypoint();
                waypointScore = score.updateWaypointScore(this.closestDistance);
                this.currentRoute.remove(0);
            }
            score.updateScore(waypointScore);
        }
    }

    public void render(Graphics g) throws SlickException {
        if (!this.currentRoute.isEmpty()) {
            if (this.flight.getOwner() == "red") {
                g.setColor(RED_COLOR);
            } else if (this.flight.getOwner() == "blue") {
                g.setColor(BLUE_COLOR);
            } else {
                g.setColor(Color.lightGray);
            }
            g.drawLine((float)this.flight.getX(), (float)this.flight.getY(), (float)this.currentRoute.get(0).getX(), (float)this.currentRoute.get(0).getY());
            for (int i = 1; i < this.currentRoute.size(); ++i) {
                g.drawLine((float)this.currentRoute.get(i).getX(), (float)this.currentRoute.get(i).getY(), (float)this.currentRoute.get(i - 1).getX(), (float)this.currentRoute.get(i - 1).getY());
            }
        }
    }

    public List<Point> getCurrentRoute() {
        return this.currentRoute;
    }

    public Point getPointByIndex(int i) {
        return this.currentRoute.get(i);
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public ExitPoint getExitPoint() {
        return this.exitPoint;
    }

    public String toString() {
        String returnString = "";
        if (this.currentRoute.size() > 0) {
            returnString = this.currentRoute.get(0).getPointRef();
        }
        for (int i = 1; i < this.currentRoute.size(); ++i) {
            returnString = returnString + ", " + this.currentRoute.get(i).getPointRef();
        }
        return returnString;
    }
}

