/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;

public class ScoreTracking {
    private static final int TIME_BONUS = 100;
    private static final int FLIGHT_LOSS_PENALTY = -50;
    private static final int CRASH_PENALTY = -500;
    private int currentScore = 0;

    public void render(Graphics g, int x, int y, Color color) throws SlickException {
        g.setColor(color);
        g.fillOval(x, (float)y + 4.0f, 10.0f, 10.0f);
        if (color == Color.white) {
            g.setColor(Color.lightGray);
        } else {
            g.setColor(Color.white);
        }
        g.drawOval(x, (float)y + 4.0f, 10.0f, 10.0f);
        g.setColor(Color.white);
        g.drawString(String.valueOf(this.currentScore), x + 15, y);
    }

    public int updateWaypointScore(int closestDistance) {
        int waypointScore = 0;
        if (closestDistance >= 0 && closestDistance <= 14) {
            waypointScore = 100;
        } else if (closestDistance >= 15 && closestDistance <= 28) {
            waypointScore = 50;
        } else if (closestDistance >= 29 && closestDistance <= 42) {
            waypointScore = 20;
        }
        return waypointScore;
    }

    public void applyTimeBonus() {
        this.currentScore += 100;
    }

    public void applyFlightLossPenalty() {
        this.currentScore += -50;
    }

    public void applyCrashPenalty() {
        this.currentScore += -500;
    }

    public int getScore() {
        return this.currentScore;
    }

    public int updateScore(int score) {
        return this.currentScore += score;
    }

    public void resetScore() {
        this.currentScore = 0;
    }
}

