/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import logicClasses.Airspace;
import logicClasses.Flight;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;

public class SeparationRules {
    public static final int LATERAL_WARNING_DISTANCE = 100;
    public static final int VERTICAL_WARNING_DISTANCE = 999;
    private int gameOverLateralSeparation;
    private int gameOverVerticalSeparation;
    private boolean gameOverViolation = false;
    private Flight violatingFlight1;
    private Flight violatingFlight2;

    public SeparationRules(int difficultyVal) {
        if (difficultyVal == 1) {
            this.gameOverLateralSeparation = 30;
            this.gameOverVerticalSeparation = 200;
        }
        if (difficultyVal == 2) {
            this.gameOverLateralSeparation = 60;
            this.gameOverVerticalSeparation = 350;
        }
        if (difficultyVal == 3) {
            this.gameOverLateralSeparation = 90;
            this.gameOverVerticalSeparation = 500;
        }
    }

    public int verticalDistanceBetweenFlights(Flight f1, Flight f2) {
        return Math.abs(f1.getAltitude() - f2.getAltitude());
    }

    public void checkViolation(Airspace airspace) {
        for (Flight e : airspace.getListOfFlights()) {
            for (Flight f : airspace.getListOfFlights()) {
                if (e == f || !(Airspace.distanceBetween(e, f) <= (double)this.gameOverLateralSeparation) || this.verticalDistanceBetweenFlights(e, f) > this.gameOverVerticalSeparation) continue;
                this.gameOverViolation = true;
                this.violatingFlight1 = e;
                this.violatingFlight2 = f;
            }
        }
    }

    public void render(Graphics g, Airspace airspace) {
        for (Flight e : airspace.getListOfFlights()) {
            for (Flight f : airspace.getListOfFlights()) {
                if (e == f || !(Airspace.distanceBetween(e, f) <= 100.0) || this.verticalDistanceBetweenFlights(e, f) > 999) continue;
                g.setColor(Color.orange);
                g.setLineWidth(2.0f);
                g.drawLine((float)e.getX(), (float)e.getY(), (float)f.getX(), (float)f.getY());
                g.setLineWidth(1.0f);
            }
        }
    }

    public void update(Airspace airspace) {
        this.checkViolation(airspace);
    }

    public void setGameOverViolation(boolean gameOverViolation) {
        this.gameOverViolation = gameOverViolation;
    }

    public boolean getGameOverViolation() {
        return this.gameOverViolation;
    }

    public Flight getViolatingFlight1() {
        return this.violatingFlight1;
    }

    public Flight getViolatingFlight2() {
        return this.violatingFlight2;
    }
}

