/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.LoadingList;
import util.DeferredFile;

public class TimeIndicator {
    private static Image clockImage;

    public static void init() throws SlickException {
        if (clockImage == null) {
            LoadingList.get().add(new DeferredFile("res/graphics/clock.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    clockImage = new Image(filename);
                }
            });
        }
    }

    public static void render(Graphics g, int time) throws SlickException {
        int elapsedSecs = time / 1000;
        int displayMins = elapsedSecs / 60;
        int displaySecs = elapsedSecs % 60;
        clockImage.draw(1125.0f, 4.0f);
        g.setColor(Color.white);
        g.drawString(String.format("%02d", displayMins) + ":" + String.format("%02d", displaySecs), 1150.0f, 10.0f);
    }
}

