/*
 * Decompiled with CFR 0.152.
 */
package logicClasses;

import logicClasses.Airspace;
import org.newdawn.slick.Color;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.LoadingList;
import util.DeferredFile;

public class WindIndicator {
    private static Image windImage;
    private float direction;

    public static void init() throws SlickException {
        if (windImage == null) {
            LoadingList.get().add(new DeferredFile("res/graphics/wind_indicator.png"){

                @Override
                public void loadFile(String filename) throws SlickException {
                    windImage = new Image(filename);
                }
            });
        }
    }

    public void render(Graphics g, int time) throws SlickException {
        this.direction += ((float)Math.cos((double)time / 2999.0) + (float)Math.sin((double)time / 1009.0)) / 3.0f;
        windImage.setRotation(this.direction);
        windImage.draw(14.0f, 550.0f);
        int displayDirection = (int)Airspace.normalizeAngle(Math.round(this.direction));
        g.setColor(Color.white);
        g.drawString("Wind:", 60.0f, 550.0f);
        g.drawString(String.valueOf(displayDirection) + "\u00b0", 60.0f, 568.0f);
    }
}

