/*
 * Decompiled with CFR 0.152.
 */
package states;

import org.lwjgl.input.Mouse;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.DeferredResource;
import org.newdawn.slick.loading.LoadingList;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import states.PlayState;
import util.DeferredFile;
import util.HoverImage;

public class DifficultyState
extends BasicGameState {
    private static Image difficultyBackground;
    private static Image easyImage;
    private static Image mediumImage;
    private static Image hardImage;
    private static Image easyHover;
    private static Image mediumHover;
    private static Image hardHover;
    private HoverImage easyButton;
    private HoverImage mediumButton;
    private HoverImage hardButton;
    public static final int EASY = 1;
    public static final int MEDIUM = 2;
    public static final int HARD = 3;

    public DifficultyState(int stateID) {
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        LoadingList loading = LoadingList.get();
        loading.add(new DeferredFile("res/graphics/difficulty_background.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                difficultyBackground = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/easy.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                easyImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/easy_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                easyHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/medium.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                mediumImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/medium_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                mediumHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/hard.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                hardImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/hard_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                hardHover = new Image(filename);
            }
        });
        loading.add(new DeferredResource(){

            @Override
            public String getDescription() {
                return "set up difficulty buttons";
            }

            @Override
            public void load() {
                DifficultyState.this.easyButton = new HoverImage(easyImage, easyHover, 100, 250);
                DifficultyState.this.mediumButton = new HoverImage(mediumImage, mediumHover, 100, 340);
                DifficultyState.this.hardButton = new HoverImage(hardImage, hardHover, 100, 430);
            }
        });
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        difficultyBackground.draw(0.0f, 0.0f);
        this.easyButton.render(posX, posY);
        this.mediumButton.render(posX, posY);
        this.hardButton.render(posX, posY);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (Mouse.isButtonDown(0)) {
            if (this.easyButton.isMouseOver(posX, posY).booleanValue()) {
                PlayState.setGameDifficulty(1);
                sbg.enterState(2);
            } else if (this.mediumButton.isMouseOver(posX, posY).booleanValue()) {
                PlayState.setGameDifficulty(2);
                sbg.enterState(2);
            } else if (this.hardButton.isMouseOver(posX, posY).booleanValue()) {
                PlayState.setGameDifficulty(3);
                sbg.enterState(2);
            }
        }
    }

    @Override
    public int getID() {
        return 6;
    }
}

