/*
 * Decompiled with CFR 0.152.
 */
package states;

import org.lwjgl.input.Mouse;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.DeferredResource;
import org.newdawn.slick.loading.LoadingList;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import util.DeferredFile;
import util.GameFont;
import util.HoverImage;

public class GameOverState
extends BasicGameState {
    private static Color backgroundColor = new Color(75, 70, 54);
    private static Image gameOverTitle;
    private static Image quitImage;
    private static Image quitHover;
    private static Image menuImage;
    private static Image menuHover;
    private static Image againImage;
    private static Image againHover;
    private static HoverImage againButton;
    private static HoverImage menuButton;
    private static HoverImage quitButton;
    private static int finalScore;

    public GameOverState(int state) {
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        LoadingList loading = LoadingList.get();
        loading.add(new DeferredFile("res/text_graphics/gameover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                gameOverTitle = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/again.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                againImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/quit.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                quitImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/menu.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                menuImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/again_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                againHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/quit_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                quitHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/menu_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                menuHover = new Image(filename);
            }
        });
        loading.add(new DeferredResource(){

            @Override
            public String getDescription() {
                return "set up GameOverState buttons";
            }

            @Override
            public void load() {
                againButton = new HoverImage(againImage, againHover, (1200 - againImage.getWidth()) / 2 + 5, 420);
                menuButton = new HoverImage(menuImage, menuHover, 20, 530);
                quitButton = new HoverImage(quitImage, quitHover, 1200 - (quitImage.getWidth() + 15), 530);
            }
        });
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        g.setBackground(backgroundColor);
        gameOverTitle.draw((1200 - gameOverTitle.getWidth()) / 2 + 5, 20.0f);
        String finalScoreString = "Your final score was " + finalScore;
        int finalScoreX = (1200 - GameFont.getFont().getWidth(finalScoreString)) / 2;
        GameFont.getFont().drawString(finalScoreX, 300.0f, finalScoreString);
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        againButton.render(posX, posY);
        menuButton.render(posX, posY);
        quitButton.render(posX, posY);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (Mouse.isButtonDown(0)) {
            if (againButton.isMouseOver(posX, posY).booleanValue()) {
                sbg.enterState(6);
            }
            if (menuButton.isMouseOver(posX, posY).booleanValue()) {
                sbg.enterState(1);
            }
            if (quitButton.isMouseOver(posX, posY).booleanValue()) {
                System.exit(0);
            }
        }
    }

    public static void setFinalScore(int score) {
        finalScore = score;
    }

    @Override
    public int getID() {
        return 4;
    }
}

