/*
 * Decompiled with CFR 0.152.
 */
package states;

import java.awt.Desktop;
import java.net.URI;
import org.lwjgl.input.Mouse;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.DeferredResource;
import org.newdawn.slick.loading.LoadingList;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import util.DeferredFile;
import util.HoverImage;

public class MenuState
extends BasicGameState {
    private static final String WEBSITE_URL = "http://teambhd.github.io/downloads/bhdmanual.pdf";
    private static Image menuBackground;
    private static Image titleImage;
    private static Image playButton;
    private static Image playHover;
    private static HoverImage play;
    private static Image quitButton;
    private static Image quitHover;
    private static HoverImage quit;
    private static Image helpButton;
    private static Image helpHover;
    private static HoverImage help;
    private static Image versusButton;
    private static Image versusHover;
    private static HoverImage versus;
    private boolean mouseBeenReleased = false;

    public MenuState(int state) {
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        LoadingList loading = LoadingList.get();
        loading.add(new DeferredFile("res/graphics/menu_background.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                menuBackground = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/title.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                titleImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/challenge.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                playButton = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/challenge_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                playHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/quit.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                quitButton = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/quit_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                quitHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/help.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                helpButton = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/help_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                helpHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/versus.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                versusButton = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/versus_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                versusHover = new Image(filename);
            }
        });
        loading.add(new DeferredResource(){

            @Override
            public String getDescription() {
                return "set up menuState buttons";
            }

            @Override
            public void load() {
                play = new HoverImage(playButton, playHover, (1200 - playButton.getWidth()) / 2 + 5, 420);
                versus = new HoverImage(versusButton, versusHover, (1200 - versusButton.getWidth()) / 2 + 5, 500);
                help = new HoverImage(helpButton, helpHover, 20, 530);
                quit = new HoverImage(quitButton, quitHover, 1200 - (quitButton.getWidth() + 15), 530);
            }
        });
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        menuBackground.draw(0.0f, 0.0f);
        titleImage.draw((1200 - titleImage.getWidth()) / 2 + 5, 0.0f);
        play.render(posX, posY);
        versus.render(posX, posY);
        help.render(posX, posY);
        quit.render(posX, posY);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (Mouse.isButtonDown(0)) {
            if (this.mouseBeenReleased) {
                this.mouseBeenReleased = false;
                if (play.isMouseOver(posX, posY).booleanValue()) {
                    sbg.enterState(6);
                }
                if (versus.isMouseOver(posX, posY).booleanValue()) {
                    sbg.enterState(3);
                }
                if (help.isMouseOver(posX, posY).booleanValue()) {
                    try {
                        Desktop.getDesktop().browse(new URI(WEBSITE_URL));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (quit.isMouseOver(posX, posY).booleanValue()) {
                    System.exit(0);
                }
            }
        } else if (!this.mouseBeenReleased) {
            this.mouseBeenReleased = true;
        }
    }

    @Override
    public int getID() {
        return 1;
    }
}

