/*
 * Decompiled with CFR 0.152.
 */
package states;

import logicClasses.Airspace;
import logicClasses.Controls;
import logicClasses.TimeIndicator;
import logicClasses.WindIndicator;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import states.PauseState;
import util.GameAudio;
import util.GameFont;
import util.KeyBindings;

public class MultiPlayState
extends BasicGameState {
    private int time = 0;
    private Airspace airspace;
    private WindIndicator windIndicator;
    private Controls redControls;
    private Controls blueControls;
    public static final Color RED_COLOR = new Color(165, 0, 0);
    public static final Color BLUE_COLOR = new Color(0, 0, 160);
    private static final int SCORE_NEEDED_TO_WIN = 3000;
    private static boolean gameBegun;

    public MultiPlayState(int state) {
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.airspace = new Airspace(true);
        this.airspace.newWaypoint(350, 150, "A");
        this.airspace.newWaypoint(400, 470, "B");
        this.airspace.newWaypoint(700, 60, "C");
        this.airspace.newWaypoint(800, 320, "D");
        this.airspace.newWaypoint(600, 418, "E");
        this.airspace.newWaypoint(500, 220, "F");
        this.airspace.newWaypoint(950, 188, "G");
        this.airspace.newWaypoint(1050, 272, "H");
        this.airspace.newWaypoint(900, 420, "I");
        this.airspace.newWaypoint(240, 250, "J");
        this.airspace.newEntryPoint(0, 400);
        this.airspace.newEntryPoint(1200, 200);
        this.airspace.newEntryPoint(600, 0);
        this.airspace.newExitPoint(800, 0, "EXP1");
        this.airspace.newExitPoint(0, 200, "EXP2");
        this.airspace.newExitPoint(1200, 300, "EXP3");
        this.airspace.newAirport(700, 300, 0, "BHD");
        this.airspace.newAirport(200, 100, 90, "DHB");
        this.redControls = new Controls(KeyBindings.redPlayerKeys, "red");
        this.blueControls = new Controls(KeyBindings.bluePlayerKeys, "blue");
        this.windIndicator = new WindIndicator();
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) {
        if (!gameBegun) {
            this.airspace.setDifficultyValueOfGame(1);
            this.airspace.createAndSetSeparationRules();
            this.airspace.resetAirspace();
            this.time = 0;
            gameBegun = true;
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        if (!g.isAntiAlias()) {
            g.setAntiAlias(true);
        }
        g.setFont(GameFont.getFont());
        this.airspace.render(g);
        this.redControls.render(g);
        this.blueControls.render(g);
        TimeIndicator.render(g, this.time);
        this.airspace.getScore("red").render(g, 10, 10, RED_COLOR);
        this.airspace.getScore("blue").render(g, 10, 30, BLUE_COLOR);
        this.windIndicator.render(g, this.time);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        this.time += delta;
        this.airspace.newFlight();
        this.airspace.update();
        this.redControls.update(gc, this.airspace);
        this.blueControls.update(gc, this.airspace);
        if (this.airspace.getSeparationRules().getGameOverViolation()) {
            GameAudio.getCrashSound().play();
            this.airspace.getScore(this.airspace.getSeparationRules().getViolatingFlight1().getOwner()).applyCrashPenalty();
            this.airspace.getScore(this.airspace.getSeparationRules().getViolatingFlight2().getOwner()).applyCrashPenalty();
            this.airspace.removeSpecificFlight(this.airspace.getSeparationRules().getViolatingFlight1());
            this.airspace.removeSpecificFlight(this.airspace.getSeparationRules().getViolatingFlight2());
            this.airspace.getSeparationRules().setGameOverViolation(false);
        }
        if (this.airspace.getScore("red").getScore() >= 3000) {
            MultiPlayState.restartGame();
            sbg.enterState(7);
        }
        if (this.airspace.getScore("blue").getScore() >= 3000) {
            MultiPlayState.restartGame();
            sbg.enterState(8);
        }
        if (gc.getInput().isKeyPressed(25)) {
            PauseState.setDestinationStateID(this.getID());
            sbg.enterState(5);
        }
        if (!GameAudio.getMusic().playing()) {
            GameAudio.getMusic().loop(1.0f, 0.5f);
        }
    }

    @Override
    public void leave(GameContainer gc, StateBasedGame sbg) {
        GameAudio.getMusic().stop();
    }

    public static void restartGame() {
        gameBegun = false;
    }

    @Override
    public int getID() {
        return 3;
    }
}

