/*
 * Decompiled with CFR 0.152.
 */
package states;

import org.lwjgl.input.Mouse;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.DeferredResource;
import org.newdawn.slick.loading.LoadingList;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import states.MultiPlayState;
import states.PlayState;
import util.DeferredFile;
import util.HoverImage;

public class PauseState
extends BasicGameState {
    private static final Color BACKGROUND_COLOR = new Color(53, 75, 70);
    private static Image pauseTitle;
    private static Image backButton;
    private static Image backButtonHover;
    private static HoverImage back;
    private static Image menuImage;
    private static Image menuHover;
    private static HoverImage menu;
    private static Image quitButton;
    private static Image quitButtonHover;
    private static HoverImage quit;
    private static int destinationStateID;

    public PauseState(int state) {
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbj) throws SlickException {
        LoadingList loading = LoadingList.get();
        loading.add(new DeferredFile("res/text_graphics/paused.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                pauseTitle = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/resume.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                backButton = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/resume_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                backButtonHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/menu.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                menuImage = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/menu_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                menuHover = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/quit.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                quitButton = new Image(filename);
            }
        });
        loading.add(new DeferredFile("res/text_graphics/quit_hover.png"){

            @Override
            public void loadFile(String filename) throws SlickException {
                quitButtonHover = new Image(filename);
            }
        });
        loading.add(new DeferredResource(){

            @Override
            public String getDescription() {
                return "set up PauseState buttons";
            }

            @Override
            public void load() {
                back = new HoverImage(backButton, backButtonHover, (1200 - backButton.getWidth()) / 2 + 5, 420);
                menu = new HoverImage(menuImage, menuHover, 20, 530);
                quit = new HoverImage(quitButton, quitButtonHover, 1200 - (quitButton.getWidth() + 15), 530);
            }
        });
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        g.setBackground(BACKGROUND_COLOR);
        pauseTitle.draw((1200 - pauseTitle.getWidth()) / 2 + 5, 20.0f);
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        back.render(posX, posY);
        menu.render(posX, posY);
        quit.render(posX, posY);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        int posX = Mouse.getX();
        int posY = 600 - Mouse.getY();
        if (gc.getInput().isKeyPressed(25)) {
            sbg.enterState(destinationStateID);
        }
        if (Mouse.isButtonDown(0)) {
            if (back.isMouseOver(posX, posY).booleanValue()) {
                sbg.enterState(destinationStateID);
            }
            if (menu.isMouseOver(posX, posY).booleanValue()) {
                PlayState.restartGame();
                MultiPlayState.restartGame();
                sbg.enterState(1);
            }
            if (quit.isMouseOver(posX, posY).booleanValue()) {
                System.exit(0);
            }
        }
    }

    public static void setDestinationStateID(int id) {
        destinationStateID = id;
    }

    @Override
    public int getID() {
        return 5;
    }

    static {
        destinationStateID = 2;
    }
}

