/*
 * Decompiled with CFR 0.152.
 */
package states;

import logicClasses.Airspace;
import logicClasses.Controls;
import logicClasses.TimeIndicator;
import logicClasses.WindIndicator;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import states.GameOverState;
import states.PauseState;
import util.GameAudio;
import util.GameFont;
import util.KeyBindings;

public class PlayState
extends BasicGameState {
    private int time = 0;
    private Airspace airspace;
    private Controls controls;
    private WindIndicator windIndicator;
    private static int difficultyLevel;
    private static boolean gameBegun;

    public PlayState(int state) {
    }

    @Override
    public void init(GameContainer gc, StateBasedGame sbg) throws SlickException {
        this.airspace = new Airspace(false);
        this.airspace.newWaypoint(350, 150, "A");
        this.airspace.newWaypoint(400, 470, "B");
        this.airspace.newWaypoint(700, 60, "C");
        this.airspace.newWaypoint(800, 320, "D");
        this.airspace.newWaypoint(600, 418, "E");
        this.airspace.newWaypoint(500, 220, "F");
        this.airspace.newWaypoint(950, 188, "G");
        this.airspace.newWaypoint(1050, 272, "H");
        this.airspace.newWaypoint(900, 420, "I");
        this.airspace.newWaypoint(240, 250, "J");
        this.airspace.newEntryPoint(0, 400);
        this.airspace.newEntryPoint(1200, 200);
        this.airspace.newEntryPoint(600, 0);
        this.airspace.newExitPoint(800, 0, "EXP1");
        this.airspace.newExitPoint(0, 200, "EXP2");
        this.airspace.newExitPoint(1200, 300, "EXP3");
        this.airspace.newAirport(700, 300, 0, "BHD");
        this.airspace.newAirport(200, 100, 90, "DHB");
        this.controls = new Controls(KeyBindings.singlePlayerKeys, "single");
        this.windIndicator = new WindIndicator();
    }

    @Override
    public void enter(GameContainer container, StateBasedGame game) {
        if (!gameBegun) {
            System.out.println("Game begun with difficulty " + difficultyLevel);
            this.airspace.setDifficultyValueOfGame(difficultyLevel);
            this.airspace.createAndSetSeparationRules();
            this.airspace.resetAirspace();
            this.time = 0;
            gameBegun = true;
        }
    }

    @Override
    public void render(GameContainer gc, StateBasedGame sbg, Graphics g) throws SlickException {
        if (!g.isAntiAlias()) {
            g.setAntiAlias(true);
        }
        g.setFont(GameFont.getFont());
        this.airspace.render(g);
        this.controls.render(g);
        TimeIndicator.render(g, this.time);
        this.airspace.getScore("single").render(g, 10, 10, Color.white);
        this.windIndicator.render(g, this.time);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame sbg, int delta) throws SlickException {
        this.time += delta;
        this.airspace.newFlight();
        this.airspace.update();
        this.controls.update(gc, this.airspace);
        if (this.airspace.getSeparationRules().getGameOverViolation()) {
            GameAudio.getCrashSound().play();
            GameOverState.setFinalScore(this.airspace.getScore("single").getScore());
            PlayState.restartGame();
            sbg.enterState(4);
        }
        if (gc.getInput().isKeyPressed(25)) {
            PauseState.setDestinationStateID(this.getID());
            sbg.enterState(5);
        }
        if (!GameAudio.getMusic().playing()) {
            GameAudio.getMusic().loop(1.0f, 0.5f);
        }
    }

    @Override
    public void leave(GameContainer gc, StateBasedGame sbg) {
        GameAudio.getMusic().stop();
    }

    public static void setGameDifficulty(int dL) {
        difficultyLevel = dL;
    }

    public static void restartGame() {
        gameBegun = false;
    }

    @Override
    public int getID() {
        return 2;
    }
}

