/*
 * Decompiled with CFR 0.152.
 */
package states;

import java.io.IOException;
import logicClasses.Airport;
import logicClasses.Airspace;
import logicClasses.EntryPoint;
import logicClasses.ExitPoint;
import logicClasses.Flight;
import logicClasses.TimeIndicator;
import logicClasses.WindIndicator;
import org.newdawn.slick.Color;
import org.newdawn.slick.GameContainer;
import org.newdawn.slick.Graphics;
import org.newdawn.slick.Image;
import org.newdawn.slick.SlickException;
import org.newdawn.slick.loading.DeferredResource;
import org.newdawn.slick.loading.LoadingList;
import org.newdawn.slick.state.BasicGameState;
import org.newdawn.slick.state.StateBasedGame;
import util.GameAudio;
import util.GameFont;

public final class SplashState
extends BasicGameState {
    private static final Color BACKGROUND_COLOR = new Color(60, 60, 60);
    private static Image loadingImage;
    private static LoadingList loading;

    public SplashState(int state) {
    }

    @Override
    public void init(GameContainer gc, StateBasedGame s) throws SlickException {
        gc.getGraphics().setBackground(BACKGROUND_COLOR);
        loadingImage = new Image("res/text_graphics/loading.png");
        GameAudio.init();
        GameFont.init();
        Airspace.init();
        Airport.init();
        Flight.init();
        ExitPoint.init();
        EntryPoint.init();
        TimeIndicator.init();
        WindIndicator.init();
    }

    @Override
    public void render(GameContainer gc, StateBasedGame s, Graphics g) throws SlickException {
        loadingImage.drawCentered(600.0f, 300.0f);
    }

    @Override
    public void update(GameContainer gc, StateBasedGame s, int delta) throws SlickException {
        if (loading.getRemainingResources() == 0) {
            s.enterState(1);
        } else {
            DeferredResource next = loading.getNext();
            try {
                System.out.println("Loading: " + next.getDescription());
                next.load();
            }
            catch (IOException e) {
                System.out.println("Failed loading:\t" + next.getDescription());
                e.printStackTrace();
            }
        }
    }

    @Override
    public int getID() {
        return 0;
    }

    static {
        loading = LoadingList.get();
    }
}

